/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.utility;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.ResultsCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.catalogloader.CatalogLoaderRegistry;
import schemacrawler.tools.catalogloader.ChainedCatalogLoader;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.ConfigUtility;
import schemacrawler.tools.utility.DatabaseConnectorUtility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.string.ObjectToStringFormat;
import us.fatehi.utility.string.StringFormat;

public final class SchemaCrawlerUtility {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerUtility.class.getName());

    public static Catalog getCatalog(DatabaseConnectionSource dataSource, SchemaCrawlerOptions schemaCrawlerOptions) {
        SchemaRetrievalOptions schemaRetrievalOptions = SchemaCrawlerUtility.matchSchemaRetrievalOptions(dataSource);
        return SchemaCrawlerUtility.getCatalog(dataSource, schemaRetrievalOptions, schemaCrawlerOptions, ConfigUtility.newConfig());
    }

    public static Catalog getCatalog(DatabaseConnectionSource dataSource, SchemaRetrievalOptions schemaRetrievalOptions, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig) {
        LOGGER.log(Level.CONFIG, (Supplier<String>)new ObjectToStringFormat((Object)schemaCrawlerOptions));
        SchemaCrawlerUtility.updateConnectionDataSource(dataSource, schemaRetrievalOptions);
        CatalogLoaderRegistry catalogLoaderRegistry = CatalogLoaderRegistry.getCatalogLoaderRegistry();
        ChainedCatalogLoader catalogLoader = catalogLoaderRegistry.newChainedCatalogLoader();
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Catalog loader: %s", new Object[]{catalogLoader}));
        catalogLoader.setDataSource(dataSource);
        catalogLoader.setSchemaRetrievalOptions(schemaRetrievalOptions);
        catalogLoader.setSchemaCrawlerOptions(schemaCrawlerOptions);
        catalogLoader.setAdditionalConfiguration(additionalConfig);
        catalogLoader.loadCatalog();
        Catalog catalog = catalogLoader.getCatalog();
        Objects.requireNonNull(catalog, "Catalog could not be retrieved");
        return catalog;
    }

    public static ResultsColumns getResultsColumns(ResultSet resultSet) {
        try {
            DatabaseUtility.checkResultSet((ResultSet)resultSet);
            ResultsCrawler resultSetCrawler = new ResultsCrawler(resultSet);
            ResultsColumns resultsColumns = resultSetCrawler.crawl();
            return resultsColumns;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException("Could not retrieve result-set metadata", e);
        }
    }

    public static SchemaRetrievalOptions matchSchemaRetrievalOptions(DatabaseConnectionSource dataSource) {
        SchemaRetrievalOptions schemaRetrievalOptions;
        block8: {
            Connection connection = (Connection)dataSource.get();
            try {
                SchemaRetrievalOptions schemaRetrievalOptions2;
                DatabaseUtility.checkConnection((Connection)connection);
                DatabaseConnector dbConnector = DatabaseConnectorUtility.findDatabaseConnector(connection);
                SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = dbConnector.getSchemaRetrievalOptionsBuilder(connection);
                schemaRetrievalOptions = schemaRetrievalOptions2 = (SchemaRetrievalOptions)schemaRetrievalOptionsBuilder.build();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new InternalRuntimeException("Could not obtain schema retrieval options", (Throwable)e);
                }
            }
            connection.close();
        }
        return schemaRetrievalOptions;
    }

    public static void updateConnectionDataSource(DatabaseConnectionSource dataSource, SchemaRetrievalOptions schemaRetrievalOptions) {
        if (dataSource == null) {
            LOGGER.log(Level.CONFIG, "No database connection source provided");
            return;
        }
        if (schemaRetrievalOptions == null) {
            LOGGER.log(Level.CONFIG, "No schema retrieval options provided");
            return;
        }
        dataSource.setFirstConnectionInitializer(schemaRetrievalOptions.getConnectionInitializer());
    }

    private SchemaCrawlerUtility() {
    }
}

