/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.text;

public final class TextParseException
extends Exception {
    private static final long serialVersionUID = -104133072151159140L;
    private final Integer line;
    private final Integer col;

    public TextParseException() {
        this.line = null;
        this.col = null;
    }

    public TextParseException(String message, Throwable throwable) {
        super(TextParseException.message(message, throwable), throwable);
        if (throwable != null && throwable instanceof TextParseException) {
            this.line = ((TextParseException)throwable).getLine();
            this.col = ((TextParseException)throwable).getCol();
        } else {
            this.line = null;
            this.col = null;
        }
    }

    public TextParseException(String message) {
        super(message);
        this.line = null;
        this.col = null;
    }

    public TextParseException(Throwable throwable) {
        super(TextParseException.message(null, throwable), throwable);
        if (throwable != null && throwable instanceof TextParseException) {
            this.line = ((TextParseException)throwable).getLine();
            this.col = ((TextParseException)throwable).getCol();
        } else {
            this.line = null;
            this.col = null;
        }
    }

    public TextParseException(int line, int col) {
        super(TextParseException.messagePrefix(line, col));
        this.line = line;
        this.col = col;
    }

    public TextParseException(String message, Throwable throwable, int line, int col) {
        super(TextParseException.messagePrefix(line, col) + " " + message, throwable);
        this.line = line;
        this.col = col;
    }

    public TextParseException(String message, int line, int col) {
        super(TextParseException.messagePrefix(line, col) + " " + message);
        this.line = line;
        this.col = col;
    }

    public TextParseException(Throwable throwable, int line, int col) {
        super(TextParseException.messagePrefix(line, col), throwable);
        this.line = line;
        this.col = col;
    }

    private static String messagePrefix(int line, int col) {
        return "(Line = " + line + ", Column = " + col + ")";
    }

    private static String message(String message, Throwable throwable) {
        TextParseException exception;
        if (throwable != null && throwable instanceof TextParseException && (exception = (TextParseException)throwable).getLine() != null && exception.getCol() != null) {
            return "(Line = " + exception.getLine() + ", Column = " + exception.getCol() + ")" + (message != null ? " " + message : throwable.getMessage());
        }
        if (message != null) {
            return message;
        }
        if (throwable != null) {
            return throwable.getMessage();
        }
        return null;
    }

    public Integer getLine() {
        return this.line;
    }

    public Integer getCol() {
        return this.col;
    }
}

