﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securitylake/SecurityLake_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityLake {
namespace Model {

/**
 * <p>The configurations used for EventBridge subscriber
 * notification.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/SqsNotificationConfiguration">AWS
 * API Reference</a></p>
 */
class SqsNotificationConfiguration {
 public:
  AWS_SECURITYLAKE_API SqsNotificationConfiguration() = default;
  AWS_SECURITYLAKE_API SqsNotificationConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYLAKE_API SqsNotificationConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYLAKE_API Aws::Utils::Json::JsonValue Jsonize() const;
};

}  // namespace Model
}  // namespace SecurityLake
}  // namespace Aws
