/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.io.DataInput;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.ExternalizableGraphElement;
import org.jetbrains.jps.dependency.FactoredExternalizableGraphElement;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.impl.RW;

public class GraphDataInputImpl
implements GraphDataInput {
    private static final MethodType ourDefaultReadConstructorType = MethodType.methodType(Void.TYPE, GraphDataInput.class);
    private static final MethodHandles.Lookup ourLookup = MethodHandles.lookup();
    private final DataInput myDelegate;

    public GraphDataInputImpl(DataInput delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.myDelegate.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.myDelegate.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.myDelegate.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.myDelegate.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.myDelegate.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.myDelegate.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.myDelegate.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.myDelegate.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.myDelegate.readChar();
    }

    @Override
    public int readInt() throws IOException {
        int val = this.myDelegate.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = this.myDelegate.readUnsignedByte();
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    @Override
    public long readLong() throws IOException {
        int val = this.myDelegate.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        long res = val - 192;
        int sh = 6;
        while (true) {
            int next = this.myDelegate.readUnsignedByte();
            res |= (long)(next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    @Override
    public float readFloat() throws IOException {
        return this.myDelegate.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.myDelegate.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.myDelegate.readLine();
    }

    @Override
    @NotNull
    public String readUTF() throws IOException {
        String string = RW.readUTF(this.myDelegate);
        if (string == null) {
            GraphDataInputImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public <T extends ExternalizableGraphElement> T readGraphElement() throws IOException {
        try {
            MethodHandle constructor;
            String className = this.readUTF();
            Class<?> elemType = Class.forName(className);
            if (FactoredExternalizableGraphElement.class.isAssignableFrom(elemType)) {
                T factorData = this.readGraphElement();
                constructor = ourLookup.findConstructor(elemType, MethodType.methodType(Void.TYPE, factorData.getClass(), GraphDataInput.class)).bindTo(factorData);
            } else {
                constructor = ourLookup.findConstructor(elemType, ourDefaultReadConstructorType);
            }
            return (T)this.processLoadedGraphElement(constructor.invoke(this));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    @Override
    public <T extends ExternalizableGraphElement, C extends Collection<? super T>> C readGraphElementCollection(C acc) throws IOException {
        try {
            String className = this.readUTF();
            final Class<?> elemType = Class.forName(className);
            if (FactoredExternalizableGraphElement.class.isAssignableFrom(elemType)) {
                int groupCount = this.readInt();
                while (groupCount-- > 0) {
                    RW.readCollection(this, new RW.Reader<T>(){
                        MethodHandle constructor;

                        @Override
                        public T read() throws IOException {
                            try {
                                if (this.constructor == null) {
                                    Object factorData = GraphDataInputImpl.this.readGraphElement();
                                    this.constructor = ourLookup.findConstructor(elemType, MethodType.methodType(Void.TYPE, factorData.getClass(), GraphDataInput.class)).bindTo(factorData);
                                }
                                return GraphDataInputImpl.this.processLoadedGraphElement(this.constructor.invoke(GraphDataInputImpl.this));
                            }
                            catch (IOException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                throw new IOException(e);
                            }
                        }
                    }, acc);
                }
                return acc;
            }
            MethodHandle constructor = ourLookup.findConstructor(elemType, ourDefaultReadConstructorType);
            return RW.readCollection(this, () -> {
                try {
                    return this.processLoadedGraphElement(constructor.invoke(this));
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new IOException(e);
                }
            }, acc);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    protected <T extends ExternalizableGraphElement> T processLoadedGraphElement(T element) {
        return element;
    }

    public static GraphDataInput wrap(DataInput in) {
        return in instanceof GraphDataInput ? (GraphDataInput)in : new GraphDataInputImpl(in);
    }

    public static GraphDataInput wrap(DataInput in, final @Nullable StringEnumerator enumerator, final Function<Object, Object> elementInterner) {
        if (enumerator != null && elementInterner != null) {
            return new GraphDataInputImpl(in){

                @Override
                @NotNull
                public String readUTF() throws IOException {
                    String string = (String)elementInterner.apply(enumerator.toString(this.readInt()));
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                protected <T extends ExternalizableGraphElement> T processLoadedGraphElement(T element) {
                    return (T)((ExternalizableGraphElement)elementInterner.apply(super.processLoadedGraphElement(element)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/dependency/impl/GraphDataInputImpl$2", "readUTF"));
                }
            };
        }
        if (elementInterner != null) {
            return new GraphDataInputImpl(in){

                @Override
                @NotNull
                public String readUTF() throws IOException {
                    String string = (String)elementInterner.apply(super.readUTF());
                    if (string == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                protected <T extends ExternalizableGraphElement> T processLoadedGraphElement(T element) {
                    return (T)((ExternalizableGraphElement)elementInterner.apply(super.processLoadedGraphElement(element)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/dependency/impl/GraphDataInputImpl$3", "readUTF"));
                }
            };
        }
        if (enumerator != null) {
            return new GraphDataInputImpl(in){

                @Override
                @NotNull
                public String readUTF() throws IOException {
                    String string = enumerator.toString(this.readInt());
                    if (string == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/dependency/impl/GraphDataInputImpl$4", "readUTF"));
                }
            };
        }
        return GraphDataInputImpl.wrap(in);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/dependency/impl/GraphDataInputImpl", "readUTF"));
    }

    public static interface StringEnumerator {
        public String toString(int var1) throws IOException;
    }
}

