/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGridNotifications;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.dump.DumpInfo;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.actions.DumpSourceNameProvider;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.Out;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.NotNullFunction;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.JBIterable;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public abstract class DumpHandler<T> {
    private static final Logger LOG = Logger.getInstance(DumpHandler.class);
    protected final Project myProject;
    protected final JBIterable<? extends T> mySources;
    protected final DumpSourceNameProvider<T> myNameProvider;
    protected final @NlsContexts.ProgressTitle String myTitle;
    private final DataExtractorFactory myFactory;
    protected final ExtractionConfig myConfig;
    protected final ExtractionHelper myManager;
    private final ErrorHandler myHandler;
    private long myLength;
    protected int myRowsCount;
    private int myProcessedCount;

    protected DumpHandler(@NotNull Project project, @NotNull JBIterable<? extends T> sources, @NotNull DumpSourceNameProvider<T> nameProvider, @NotNull ExtractionHelper manager, @NotNull String displayName, @NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
        if (project == null) {
            DumpHandler.$$$reportNull$$$0(0);
        }
        if (sources == null) {
            DumpHandler.$$$reportNull$$$0(1);
        }
        if (nameProvider == null) {
            DumpHandler.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            DumpHandler.$$$reportNull$$$0(3);
        }
        if (displayName == null) {
            DumpHandler.$$$reportNull$$$0(4);
        }
        if (factory == null) {
            DumpHandler.$$$reportNull$$$0(5);
        }
        if (config == null) {
            DumpHandler.$$$reportNull$$$0(6);
        }
        this.myProject = project;
        this.myManager = manager;
        this.mySources = sources;
        this.myNameProvider = nameProvider;
        this.myTitle = this.myManager.getTitle(displayName);
        this.myFactory = factory;
        this.myConfig = config;
        this.myHandler = new ErrorHandler();
    }

    @NotNull
    protected abstract ExtractorConfig createExtractorConfig(@NotNull T var1, @Nullable Project var2);

    protected int getSubQueryIndex(@NotNull T source) {
        if (source == null) {
            DumpHandler.$$$reportNull$$$0(7);
        }
        return 0;
    }

    protected abstract int getResultSetIndex(@NotNull T var1);

    @Nullable
    protected abstract ModelIndexSet<GridColumn> getSelectedColumns(@NotNull T var1);

    @Nullable
    protected abstract AsyncPromise<Void> run(@NotNull T var1, @NotNull DataExtractor var2, @NotNull Out var3, @NotNull DumpHandlerParameters var4);

    @NlsSafe
    @Nullable
    protected abstract String getDatabaseSystemName();

    @Nullable
    protected abstract String getProducerName();

    @Nullable
    protected abstract String getSourceName(int var1);

    @Nullable
    protected ObjectFormatter getFormatter(@NotNull T source) {
        if (source == null) {
            DumpHandler.$$$reportNull$$$0(8);
        }
        return null;
    }

    @NotNull
    protected NotNullFunction<DataExtractor, GridDataRequest> newSimpleRunner(@NotNull DataProducer producer, GridDataRequest.GridDataRequestOwner owner, @NotNull Out out, @NotNull DumpHandlerParameters dumpParameters) {
        if (producer == null) {
            DumpHandler.$$$reportNull$$$0(9);
        }
        if (out == null) {
            DumpHandler.$$$reportNull$$$0(10);
        }
        if (dumpParameters == null) {
            DumpHandler.$$$reportNull$$$0(11);
        }
        NotNullFunction notNullFunction = extractor -> {
            GridDataRequest request = this.createDumpRequest(owner, (DataExtractor)extractor, out, null, dumpParameters);
            producer.processRequest(request);
            return request;
        };
        if (notNullFunction == null) {
            DumpHandler.$$$reportNull$$$0(12);
        }
        return notNullFunction;
    }

    protected final boolean isSingleSource() {
        return this.mySources.skip(1).isEmpty();
    }

    private void processError(@Nullable Throwable th) {
        this.myHandler.addError(null, th);
    }

    public void performDump(@Nullable Project project) {
        Task.Backgroundable task = this.buildTask(this.myFactory, project);
        if (task == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)task);
    }

    @Nullable
    public Task.Backgroundable buildTask(@NotNull DataExtractorFactory factory, @Nullable Project project) {
        if (factory == null) {
            DumpHandler.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.assertEventDispatchThread();
        final List pairs = this.mySources.map(s -> {
            int subQueryIndex = this.getSubQueryIndex(s);
            int resultSetIndex = this.getResultSetIndex(s);
            ModelIndexSet<GridColumn> selectedColumns = this.getSelectedColumns(s);
            String queryText = this.myNameProvider.getQueryText(s);
            if (queryText == null) {
                queryText = "";
            }
            String name = this.myNameProvider.getName(s);
            DataExtractor extractor = factory.createExtractor(this.createExtractorConfig(s, project));
            return extractor != null ? new Triple(s, (Object)extractor, (Object)new DumpHandlerParameters(selectedColumns, queryText, subQueryIndex, resultSetIndex, name)) : null;
        }).filter(p -> p != null).toList();
        if (pairs.isEmpty()) {
            return null;
        }
        return new Task.Backgroundable(this.myProject, this.myTitle){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText(DataGridBundle.message((String)"progress.text.initializing.output", (Object[])new Object[0]));
                indicator.setIndeterminate(true);
                Out previousOutput = null;
                try {
                    for (Triple p : pairs) {
                        indicator.checkCanceled();
                        if (p.getSecond() == null) continue;
                        previousOutput = DumpHandler.this.processSource(p.getFirst(), (DataExtractor)p.getSecond(), indicator, (DumpHandlerParameters)p.getThird(), previousOutput);
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    DumpHandler.this.dumpFinished(previousOutput);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dump/DumpHandler$1", "run"));
            }
        };
    }

    private void dumpFinished(@Nullable Out lastOutput) {
        try {
            String systemName = this.getDatabaseSystemName();
            DumpInfo info = new DumpInfo(systemName != null ? systemName : DataGridBundle.message((String)"notification.title.data.dump", (Object[])new Object[0]), this.myHandler.getSummary(), this.getSourceName(this.myProcessedCount), this.getProducerName(), this.myRowsCount, this.myProcessedCount);
            if (lastOutput != null && this.myManager.isSingleFileMode()) {
                lastOutput.close();
            }
            this.myManager.after(this.myProject, info);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                LOG.warn((Throwable)e);
                return;
            }
            DataGridNotifications.EXTRACTORS_GROUP.createNotification(DataGridBundle.message((String)"notification.title.data.dump", (Object[])new Object[0]), message, NotificationType.ERROR).setDisplayId("DumpHandler.error").notify(this.myProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Out processSource(@NotNull T source, @NotNull DataExtractor extractor, @NotNull ProgressIndicator indicator, @NotNull DumpHandlerParameters dumpParameters, @Nullable Out previousOutput) {
        Out output;
        if (source == null) {
            DumpHandler.$$$reportNull$$$0(14);
        }
        if (extractor == null) {
            DumpHandler.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            DumpHandler.$$$reportNull$$$0(16);
        }
        if (dumpParameters == null) {
            DumpHandler.$$$reportNull$$$0(17);
        }
        AsyncFutureResult result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        try {
            output = this.refreshOut(dumpParameters.name, extractor, previousOutput);
        }
        catch (Exception e) {
            this.processError(e);
            return null;
        }
        indicator.setText(DataGridBundle.message((String)"progress.text.running.query", (Object[])new Object[0]));
        AsyncPromise<Void> promise = this.run(source, extractor, output, dumpParameters);
        if (promise == null) {
            return output;
        }
        promise.onProcessed(o -> result.set((Object)true));
        try {
            result.get();
        }
        catch (Exception e) {
            this.processError(e);
        }
        finally {
            ++this.myProcessedCount;
            this.sourceDumped(extractor, output);
        }
        return output;
    }

    @NotNull
    private Out refreshOut(@Nullable String name, @NotNull DataExtractor extractor, @Nullable Out previousOutput) throws Exception {
        if (extractor == null) {
            DumpHandler.$$$reportNull$$$0(18);
        }
        if (this.myManager.isSingleFileMode() && previousOutput != null) {
            if (previousOutput instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream arrayOutput = (ByteArrayOutputStream)previousOutput;
                if (extractor.supportsText()) {
                    if ((long)arrayOutput.size() > this.myLength) {
                        arrayOutput.write("\n".getBytes(StandardCharsets.UTF_8));
                    }
                    this.myLength = arrayOutput.size();
                }
            }
            Out out = previousOutput;
            if (out == null) {
                DumpHandler.$$$reportNull$$$0(19);
            }
            return out;
        }
        Out out = this.myManager.createOut(name, extractor);
        if (out == null) {
            DumpHandler.$$$reportNull$$$0(20);
        }
        return out;
    }

    private void sourceDumped(@NotNull DataExtractor extractor, @NotNull Out out) {
        if (extractor == null) {
            DumpHandler.$$$reportNull$$$0(21);
        }
        if (out == null) {
            DumpHandler.$$$reportNull$$$0(22);
        }
        if (this.myManager.isSingleFileMode()) {
            return;
        }
        try {
            this.myManager.sourceDumped(extractor, out);
            out.close();
        }
        catch (Exception ex) {
            this.processError(ex);
        }
    }

    @NotNull
    protected abstract GridDataRequest createDumpRequest(@NotNull GridDataRequest.GridDataRequestOwner var1, DataExtractor var2, @NotNull Out var3, @Nullable String var4, @NotNull DumpHandlerParameters var5);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 7: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpParameters";
                break;
            }
            case 12: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dump/DumpHandler";
                break;
            }
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dump/DumpHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newSimpleRunner";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshOut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSubQueryIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFormatter";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newSimpleRunner";
                break;
            }
            case 12: 
            case 19: 
            case 20: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildTask";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processSource";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "refreshOut";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sourceDumped";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 19, 20 -> new IllegalStateException(string);
        };
    }

    public static class DumpHandlerParameters {
        public final ModelIndexSet<GridColumn> selectedColumns;
        public final String queryText;
        public final int subQueryIndex;
        public final int resultSetIndex;
        private final String name;

        private DumpHandlerParameters(@Nullable ModelIndexSet<GridColumn> selectedColumns, @NotNull String queryText, int subQueryIndex, int resultSetIndex, @Nullable String name) {
            if (queryText == null) {
                DumpHandlerParameters.$$$reportNull$$$0(0);
            }
            this.selectedColumns = selectedColumns;
            this.queryText = queryText;
            this.subQueryIndex = subQueryIndex;
            this.resultSetIndex = resultSetIndex;
            this.name = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/dump/DumpHandler$DumpHandlerParameters", "<init>"));
        }
    }
}

