/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.DirectoryContentBuilder;
import com.intellij.util.io.DirectoryContentSpec;
import com.intellij.util.io.impl.DirectoryContentBuilderImpl;
import com.intellij.util.io.impl.JarSpec;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\rH\u0007J\u0006\u0010 \u001a\u00020\tJ\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0005H\u0007J\u000e\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u0005J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0005H\u0007J\u001a\u0010\"\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010$H\u0007J\u001c\u0010%\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u00052\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0007J\u000e\u0010&\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010'\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0005J\u0018\u0010'\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010$J\u000e\u0010(\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0005J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\tH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lcom/intellij/testFramework/rules/TempDirectory;", "Lorg/junit/rules/ExternalResource;", "<init>", "()V", "myName", "", "myNextDirNameSuffix", "Ljava/util/concurrent/atomic/AtomicInteger;", "myRoot", "Ljava/nio/file/Path;", "myVirtualFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "Ljava/io/File;", "getRoot", "()Ljava/io/File;", "rootPath", "getRootPath", "()Ljava/nio/file/Path;", "virtualFileRoot", "getVirtualFileRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "before", "", "methodName", "after", "newDirectory", "newDirectoryPath", "relativePath", "newFile", "content", "", "newFileNio", "newVirtualDirectory", "newVirtualFile", "newEmptyVirtualJarFile", "makeDirectories", "path", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nTempDirectory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TempDirectory.kt\ncom/intellij/testFramework/rules/TempDirectory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DirectoryContentSpec.kt\ncom/intellij/util/io/DirectoryContentSpecKt\n*L\n1#1,186:1\n1#2:187\n40#3,3:188\n*S KotlinDebug\n*F\n+ 1 TempDirectory.kt\ncom/intellij/testFramework/rules/TempDirectory\n*L\n164#1:188,3\n*E\n"})
public class TempDirectory
extends ExternalResource {
    @Nullable
    private String myName;
    @NotNull
    private final AtomicInteger myNextDirNameSuffix = new AtomicInteger();
    @Nullable
    private Path myRoot;
    @Nullable
    private VirtualFile myVirtualFileRoot;

    @ApiStatus.Obsolete
    @NotNull
    public final File getRoot() {
        File file = this.getRootPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @NotNull
    public final Path getRootPath() {
        if (this.myRoot == null) {
            if (this.myName == null) {
                boolean bl = false;
                String string = "apply() was not called";
                throw new IllegalStateException(string.toString());
            }
            this.myRoot = Files.createTempDirectory("unitTest_" + this.myName + "_", new FileAttribute[0]).toRealPath(new LinkOption[0]);
        }
        Path path = this.myRoot;
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    @NotNull
    public final VirtualFile getVirtualFileRoot() {
        if (this.myVirtualFileRoot == null) {
            this.myVirtualFileRoot = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(this.getRootPath());
            if (this.myVirtualFileRoot == null) {
                boolean bl = false;
                String string = "Cannot find virtual file by " + this.getRootPath();
                throw new IllegalStateException(string.toString());
            }
            VirtualFile[] virtualFileArray = new VirtualFile[]{this.myVirtualFileRoot};
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
        }
        VirtualFile virtualFile = this.myVirtualFileRoot;
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = description.getMethodName();
        if (string == null) {
            string = description.getClassName();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        this.before(string2);
        Statement statement2 = super.apply(base, description);
        Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"apply(...)");
        return statement2;
    }

    public final void before(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        this.myName = PlatformTestUtil.lowercaseFirstLetter(FileUtil.sanitizeFileName((String)StringsKt.take((String)methodName, (int)30), (boolean)true), true);
    }

    public void after() {
        Path path = this.myRoot;
        VirtualFile vfsDir = this.myVirtualFileRoot;
        this.myVirtualFileRoot = null;
        this.myRoot = null;
        this.myName = null;
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[]{TempDirectory::after$lambda$0, () -> TempDirectory.after$lambda$1(vfsDir), () -> TempDirectory.after$lambda$2(path)};
        new RunAll(throwableRunnableArray).run();
    }

    @ApiStatus.Obsolete
    @NotNull
    public final File newDirectory() {
        File file = this.newDirectoryPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @NotNull
    public final Path newDirectoryPath() {
        return this.newDirectoryPath("dir" + this.myNextDirNameSuffix.incrementAndGet());
    }

    @ApiStatus.Obsolete
    @NotNull
    public final File newDirectory(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        File file = this.newDirectoryPath(relativePath).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @NotNull
    public final Path newDirectoryPath(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path dir = this.getRootPath().resolve(relativePath);
        if (!(!Files.exists(dir, new LinkOption[0]))) {
            boolean bl = false;
            String string = "Already exists: " + dir;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)dir);
        this.makeDirectories(dir);
        return dir;
    }

    @ApiStatus.Obsolete
    @NotNull
    public final File newFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        File file = TempDirectory.newFileNio$default(this, relativePath, null, 2, null).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @ApiStatus.Obsolete
    @NotNull
    public final File newFile(@NotNull String relativePath, @Nullable byte[] content) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        File file = this.newFileNio(relativePath, content).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @JvmOverloads
    @NotNull
    public final Path newFileNio(@NotNull String relativePath, @Nullable byte[] content) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path file = this.getRootPath().resolve(relativePath);
        if (!(!Files.exists(file, new LinkOption[0]))) {
            boolean bl = false;
            String string = "Already exists: " + file;
            throw new IllegalArgumentException(string.toString());
        }
        Path path = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        this.makeDirectories(path);
        Files.createFile(file, new FileAttribute[0]);
        if (content != null) {
            Files.write(file, content, new OpenOption[0]);
        }
        Intrinsics.checkNotNull((Object)file);
        return file;
    }

    public static /* synthetic */ Path newFileNio$default(TempDirectory tempDirectory, String string, byte[] byArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newFileNio");
        }
        if ((n & 2) != 0) {
            byArray = null;
        }
        return tempDirectory.newFileNio(string, byArray);
    }

    @NotNull
    public final VirtualFile newVirtualDirectory(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile existing = this.getVirtualFileRoot().findFileByRelativePath(relativePath);
        if (!(existing == null)) {
            boolean bl = false;
            VirtualFile virtualFile = existing;
            Intrinsics.checkNotNull((Object)virtualFile);
            String string = "Already exists: " + virtualFile.getPath();
            throw new IllegalArgumentException(string.toString());
        }
        VirtualFile virtualFile = VfsTestUtil.createDir(this.getVirtualFileRoot(), relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createDir(...)");
        return virtualFile;
    }

    @NotNull
    public final VirtualFile newVirtualFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.newVirtualFile(relativePath, null);
    }

    @NotNull
    public final VirtualFile newVirtualFile(@NotNull String relativePath, @Nullable byte[] content) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile existing = this.getVirtualFileRoot().findFileByRelativePath(relativePath);
        if (!(existing == null)) {
            boolean bl = false;
            VirtualFile virtualFile = existing;
            Intrinsics.checkNotNull((Object)virtualFile);
            String string = "Already exists: " + virtualFile.getPath();
            throw new IllegalArgumentException(string.toString());
        }
        VirtualFile virtualFile = VfsTestUtil.createFile(this.getVirtualFileRoot(), relativePath, content);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createFile(...)");
        return virtualFile;
    }

    @NotNull
    public final VirtualFile newEmptyVirtualJarFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile existing = this.getVirtualFileRoot().findFileByRelativePath(relativePath);
        if (!(existing == null)) {
            boolean $i$a$-require-TempDirectory$newEmptyVirtualJarFile$22 = false;
            VirtualFile virtualFile = existing;
            Intrinsics.checkNotNull((Object)virtualFile);
            String $i$a$-require-TempDirectory$newEmptyVirtualJarFile$22 = "Already exists: " + virtualFile.getPath();
            throw new IllegalArgumentException($i$a$-require-TempDirectory$newEmptyVirtualJarFile$22.toString());
        }
        Path jarFile = this.getRootPath().resolve(relativePath);
        boolean $i$f$jarFile = false;
        DirectoryContentBuilderImpl builder$iv = new DirectoryContentBuilderImpl(new JarSpec());
        DirectoryContentBuilder $this$newEmptyVirtualJarFile_u24lambda_u241 = builder$iv;
        boolean bl = false;
        DirectoryContentSpec directoryContentSpec = builder$iv.getResult();
        Intrinsics.checkNotNull((Object)jarFile);
        directoryContentSpec.generate(jarFile);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(jarFile);
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile localFile = virtualFile;
        VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(localFile);
        Intrinsics.checkNotNull((Object)virtualFile2);
        return virtualFile2;
    }

    private final void makeDirectories(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Path path2 = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            this.makeDirectories(path2);
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    @JvmOverloads
    @NotNull
    public final Path newFileNio(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return TempDirectory.newFileNio$default(this, relativePath, null, 2, null);
    }

    private static final void after$lambda$0() {
        JarFileSystemImpl.cleanupForNextTest();
    }

    private static final void after$lambda$1(VirtualFile $vfsDir) {
        if ($vfsDir != null) {
            VfsTestUtil.deleteFile($vfsDir);
        }
    }

    private static final void after$lambda$2(Path $path) {
        if ($path != null) {
            NioFiles.deleteRecursively((Path)$path);
        }
    }
}

