﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/network-firewall/NetworkFirewall_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace NetworkFirewall {
namespace Model {

/**
 * <p>A single port range specification. This is used for source and destination
 * port ranges in the stateless rule <a>MatchAttributes</a>,
 * <code>SourcePorts</code>, and <code>DestinationPorts</code> settings.
 * </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/PortRange">AWS
 * API Reference</a></p>
 */
class PortRange {
 public:
  AWS_NETWORKFIREWALL_API PortRange() = default;
  AWS_NETWORKFIREWALL_API PortRange(Aws::Utils::Json::JsonView jsonValue);
  AWS_NETWORKFIREWALL_API PortRange& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_NETWORKFIREWALL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The lower limit of the port range. This must be less than or equal to the
   * <code>ToPort</code> specification. </p>
   */
  inline int GetFromPort() const { return m_fromPort; }
  inline bool FromPortHasBeenSet() const { return m_fromPortHasBeenSet; }
  inline void SetFromPort(int value) {
    m_fromPortHasBeenSet = true;
    m_fromPort = value;
  }
  inline PortRange& WithFromPort(int value) {
    SetFromPort(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The upper limit of the port range. This must be greater than or equal to the
   * <code>FromPort</code> specification. </p>
   */
  inline int GetToPort() const { return m_toPort; }
  inline bool ToPortHasBeenSet() const { return m_toPortHasBeenSet; }
  inline void SetToPort(int value) {
    m_toPortHasBeenSet = true;
    m_toPort = value;
  }
  inline PortRange& WithToPort(int value) {
    SetToPort(value);
    return *this;
  }
  ///@}
 private:
  int m_fromPort{0};

  int m_toPort{0};
  bool m_fromPortHasBeenSet = false;
  bool m_toPortHasBeenSet = false;
};

}  // namespace Model
}  // namespace NetworkFirewall
}  // namespace Aws
