﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/LocalGateway.h>
#include <aws/ec2/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class DescribeLocalGatewaysResponse {
 public:
  AWS_EC2_API DescribeLocalGatewaysResponse() = default;
  AWS_EC2_API DescribeLocalGatewaysResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API DescribeLocalGatewaysResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the local gateways.</p>
   */
  inline const Aws::Vector<LocalGateway>& GetLocalGateways() const { return m_localGateways; }
  template <typename LocalGatewaysT = Aws::Vector<LocalGateway>>
  void SetLocalGateways(LocalGatewaysT&& value) {
    m_localGatewaysHasBeenSet = true;
    m_localGateways = std::forward<LocalGatewaysT>(value);
  }
  template <typename LocalGatewaysT = Aws::Vector<LocalGateway>>
  DescribeLocalGatewaysResponse& WithLocalGateways(LocalGatewaysT&& value) {
    SetLocalGateways(std::forward<LocalGatewaysT>(value));
    return *this;
  }
  template <typename LocalGatewaysT = LocalGateway>
  DescribeLocalGatewaysResponse& AddLocalGateways(LocalGatewaysT&& value) {
    m_localGatewaysHasBeenSet = true;
    m_localGateways.emplace_back(std::forward<LocalGatewaysT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to use to retrieve the next page of results. This value is
   * <code>null</code> when there are no more results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeLocalGatewaysResponse& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeLocalGatewaysResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<LocalGateway> m_localGateways;

  Aws::String m_nextToken;

  ResponseMetadata m_responseMetadata;
  bool m_localGatewaysHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
