/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc;

import io.sf.carte.doc.StringList;
import io.sf.carte.doc.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.UnaryOperator;

public class WrapperStringList
implements StringList,
Iterable<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection<String> collection;

    public WrapperStringList(Collection<String> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        this.collection = collection;
    }

    @Override
    public String item(int n) {
        if (n >= 0 && n < this.collection.size()) {
            return this.get(n);
        }
        return null;
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public boolean contains(String string) {
        return this.collection.contains(string);
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.collection.contains(object);
    }

    @Override
    public Iterator<String> iterator() {
        return new UnmodifiableIterator<String>(this.collection.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.collection.toArray(TArray);
    }

    @Override
    public boolean add(String string) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.collection.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public boolean addAll(int n, Collection<? extends String> collection) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public void replaceAll(UnaryOperator<String> unaryOperator) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public void sort(Comparator<? super String> comparator) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public String get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + n);
        }
        int n2 = 0;
        for (String string : this.collection) {
            if (n2 == n) {
                return string;
            }
            ++n2;
        }
        throw new IndexOutOfBoundsException("Invalid index: " + n);
    }

    @Override
    public String set(int n, String string) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public void add(int n, String string) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public String remove(int n) {
        throw new UnsupportedOperationException("Unmodifiable list.");
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        for (String string : this.collection) {
            if (object == string) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = 0;
        int n2 = -1;
        for (String string : this.collection) {
            if (object == string) {
                n2 = n;
            }
            ++n;
        }
        return n2;
    }

    @Override
    public ListIterator<String> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<String> listIterator(int n) {
        throw new UnsupportedOperationException();
    }

    public StringList subList(int n, int n2) {
        if (n < 0 || n > n2 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        String[] stringArray = this.collection.toArray(new String[0]);
        stringArray = Arrays.copyOfRange(stringArray, n, n2);
        return new WrapperStringList(Collections.unmodifiableList(Arrays.asList(stringArray)));
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.collection.spliterator();
    }

    @Override
    public WrapperStringList clone() {
        return new WrapperStringList(this);
    }
}

