/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class NativeStringIterator
extends ES6Iterator {
    private static final long serialVersionUID = 1L;
    private static final String ITERATOR_TAG = "StringIterator";
    private String string;
    private int index;

    static void init(ScriptableObject scriptableObject, boolean bl) {
        ES6Iterator.init(scriptableObject, bl, new NativeStringIterator(), ITERATOR_TAG);
    }

    private NativeStringIterator() {
    }

    NativeStringIterator(Scriptable scriptable, Object object) {
        super(scriptable, ITERATOR_TAG);
        this.index = 0;
        this.string = ScriptRuntime.toString(object);
    }

    @Override
    public String getClassName() {
        return "String Iterator";
    }

    @Override
    protected boolean isDone(Context context, Scriptable scriptable) {
        return this.index >= this.string.length();
    }

    @Override
    protected Object nextValue(Context context, Scriptable scriptable) {
        int n = this.string.offsetByCodePoints(this.index, 1);
        String string = this.string.substring(this.index, n);
        this.index = n;
        return string;
    }

    @Override
    protected String getTag() {
        return ITERATOR_TAG;
    }
}

