/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util;

import io.sf.carte.echosvg.util.CleanerThread;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SoftReferenceCache {
    protected final Map<Object, SoftReference<Object>> map = new HashMap<Object, SoftReference<Object>>();
    private final boolean synchronous;

    protected SoftReferenceCache() {
        this(false);
    }

    protected SoftReferenceCache(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public synchronized void flush() {
        this.map.clear();
        this.notifyAll();
    }

    protected final synchronized boolean isPresentImpl(Object key) {
        if (!this.map.containsKey(key)) {
            return false;
        }
        SoftReference<Object> sr = this.map.get(key);
        if (sr == null) {
            return true;
        }
        Object o = sr.get();
        if (o != null) {
            return true;
        }
        this.clearImpl(key);
        return false;
    }

    protected final synchronized boolean isDoneImpl(Object key) {
        SoftReference<Object> sr = this.map.get(key);
        if (sr == null) {
            return false;
        }
        Object o = sr.get();
        if (o != null) {
            return true;
        }
        this.clearImpl(key);
        return false;
    }

    protected final synchronized Object requestImpl(Object key) {
        if (this.map.containsKey(key)) {
            Object o;
            SoftReference<Object> sr = this.map.get(key);
            while (sr == null) {
                if (this.synchronous) {
                    return null;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.map.containsKey(key)) break;
                sr = this.map.get(key);
            }
            if (sr != null && (o = sr.get()) != null) {
                return o;
            }
        }
        this.map.put(key, null);
        return null;
    }

    protected final synchronized void clearImpl(Object key) {
        this.map.remove(key);
        this.notifyAll();
    }

    protected final synchronized void putImpl(Object key, Object object) {
        if (this.map.containsKey(key)) {
            SoftRefKey ref = new SoftRefKey(object, key);
            this.map.put(key, ref);
            this.notifyAll();
        }
    }

    class SoftRefKey
    extends CleanerThread.SoftReferenceCleared<Object> {
        Object key;

        public SoftRefKey(Object o, Object key) {
            super(o);
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleared() {
            SoftReferenceCache cache;
            SoftReferenceCache softReferenceCache = cache = SoftReferenceCache.this;
            synchronized (softReferenceCache) {
                if (!cache.map.containsKey(this.key)) {
                    return;
                }
                SoftReference<Object> o = cache.map.remove(this.key);
                if (this == o) {
                    cache.notifyAll();
                } else {
                    cache.map.put(this.key, o);
                }
            }
        }
    }
}

