/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.SVG12DOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGDOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.dom.svg.SVGDocumentFactory;
import io.sf.carte.echosvg.dom.util.SAXDocumentFactory;
import io.sf.carte.echosvg.util.MimeTypeConstants;
import io.sf.carte.echosvg.util.ParsedURL;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.svg.SVGDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXSVGDocumentFactory
extends SAXDocumentFactory
implements SVGDocumentFactory {
    private static final String HTTP_CHARSET = "charset";

    public SAXSVGDocumentFactory() {
        this(null);
    }

    public SAXSVGDocumentFactory(XMLReader reader) {
        this(reader, false);
    }

    public SAXSVGDocumentFactory(XMLReader reader, boolean dd) {
        super(SVGDOMImplementation.getDOMImplementation(), reader, dd);
    }

    public SVGDocument createSVGDocument(String uri) throws IOException {
        return this.createDocument(uri);
    }

    public SVGDocument createSVGDocument(String uri, InputStream inp) throws IOException {
        return this.createDocument(uri, inp, null);
    }

    public SVGDocument createSVGDocument(String uri, Reader r) throws IOException {
        return this.createDocument(uri, r);
    }

    public SVGDocument createDocument(String uri) throws IOException {
        return this.createDocumentWithDefaultEncoding(uri, null);
    }

    public SVGDocument createDocument(String uri, String encoding) throws IOException {
        return this.createDocumentWithDefaultEncoding(uri, encoding);
    }

    private SVGDocument createDocumentWithDefaultEncoding(String uri, String encoding) throws IOException {
        int i;
        int eqIdx;
        ParsedURL purl = new ParsedURL(uri);
        InputStream is = purl.openStream(MimeTypeConstants.MIME_TYPES_SVG_LIST.iterator());
        uri = purl.getPostConnectionURL();
        InputSource isrc = new InputSource(is);
        String contentType = purl.getContentType();
        int cindex = -1;
        if (contentType != null) {
            contentType = contentType.toLowerCase();
            cindex = contentType.indexOf(HTTP_CHARSET);
        }
        String charset = encoding;
        if (cindex != -1 && (eqIdx = contentType.indexOf(61, i = cindex + HTTP_CHARSET.length())) != -1) {
            int idx = contentType.indexOf(44, ++eqIdx);
            int semiIdx = contentType.indexOf(59, eqIdx);
            if (semiIdx != -1 && (semiIdx < idx || idx == -1)) {
                idx = semiIdx;
            }
            charset = idx != -1 ? contentType.substring(eqIdx, idx) : contentType.substring(eqIdx);
            charset = charset.trim();
        }
        isrc.setEncoding(charset);
        isrc.setSystemId(uri);
        SVGOMDocument doc = (SVGOMDocument)((Object)super.createDocument("http://www.w3.org/2000/svg", "svg", uri, isrc));
        doc.setParsedURL(new ParsedURL(uri));
        doc.setDocumentInputEncoding(charset);
        doc.setXmlStandalone(this.isStandalone());
        doc.setXmlVersion(this.getXmlVersion());
        is.close();
        return doc;
    }

    public SVGDocument createDocument(String uri, InputStream inp) throws IOException {
        return this.createDocument(uri, inp, null);
    }

    public SVGDocument createDocument(String uri, InputStream inp, String encoding) throws IOException {
        SVGOMDocument doc;
        InputSource is = new InputSource(inp);
        is.setSystemId(uri);
        is.setEncoding(encoding);
        try {
            doc = (SVGOMDocument)((Object)super.createDocument("http://www.w3.org/2000/svg", "svg", uri, is));
            if (uri != null) {
                doc.setParsedURL(new ParsedURL(uri));
            }
            SVGOMDocument d = doc;
            d.setDocumentURI(uri);
            d.setXmlStandalone(this.isStandalone());
            d.setXmlVersion(this.getXmlVersion());
        }
        catch (MalformedURLException e) {
            throw new IOException(e.getMessage());
        }
        return doc;
    }

    public SVGDocument createDocument(String uri, Reader r) throws IOException {
        SVGOMDocument doc;
        InputSource is = new InputSource(r);
        is.setSystemId(uri);
        try {
            doc = (SVGOMDocument)((Object)super.createDocument("http://www.w3.org/2000/svg", "svg", uri, is));
            if (uri != null) {
                doc.setParsedURL(new ParsedURL(uri));
            }
            SVGOMDocument d = doc;
            d.setDocumentURI(uri);
            d.setXmlStandalone(this.isStandalone());
            d.setXmlVersion(this.getXmlVersion());
        }
        catch (MalformedURLException e) {
            throw new IOException(e.getMessage());
        }
        return doc;
    }

    public SVGDocument createDocument(String ns, String root, String uri) throws IOException {
        return this.createDocument(uri);
    }

    public SVGDocument createDocument(String ns, String root, String uri, String encoding) throws IOException {
        return this.createDocument(uri, encoding);
    }

    protected void checkRootElement(String ns, String root) {
        if (!"http://www.w3.org/2000/svg".equals(ns) || !"svg".equals(root)) {
            throw new IllegalArgumentException("Bad root element");
        }
    }

    public SVGDocument createDocument(String ns, String root, String uri, InputStream is) throws IOException {
        return this.createDocument(uri, is, null);
    }

    public SVGDocument createDocument(String ns, String root, String uri, InputStream is, String encoding) throws IOException {
        return this.createDocument(uri, is, encoding);
    }

    public SVGDocument createDocument(String ns, String root, String uri, Reader r) throws IOException {
        return this.createDocument(uri, r);
    }

    public DOMImplementation getDOMImplementation(String ver) {
        if (!"1.2".equals(ver)) {
            return SVGDOMImplementation.getDOMImplementation();
        }
        return SVG12DOMImplementation.getDOMImplementation();
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }
}

