/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.xml.dtd;

import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class StackedEntityResolver
implements EntityResolver2 {
    private final EntityResolver2 firstResolver;
    private final EntityResolver2 fallbackResolver;

    public StackedEntityResolver(EntityResolver2 firstResolver, EntityResolver2 fallbackResolver) {
        if (firstResolver == null || fallbackResolver == null) {
            throw new NullPointerException("Null resolver.");
        }
        this.firstResolver = firstResolver;
        this.fallbackResolver = fallbackResolver;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        InputSource source;
        SAXException saxex = null;
        IOException ioex = null;
        try {
            source = this.firstResolver.getExternalSubset(name, baseURI);
        }
        catch (SAXException e) {
            saxex = e;
            source = null;
        }
        catch (IOException e) {
            ioex = e;
            source = null;
        }
        if (source == null && (source = this.fallbackResolver.getExternalSubset(name, baseURI)) == null) {
            if (ioex != null) {
                throw ioex;
            }
            if (saxex != null) {
                throw saxex;
            }
        }
        return source;
    }

    @Override
    public final InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        InputSource source;
        SAXException saxex = null;
        IOException ioex = null;
        try {
            source = this.firstResolver.resolveEntity(name, publicId, baseURI, systemId);
        }
        catch (SAXException e) {
            saxex = e;
            source = null;
        }
        catch (IOException e) {
            ioex = e;
            source = null;
        }
        if (source == null && (source = this.fallbackResolver.resolveEntity(name, publicId, baseURI, systemId)) == null) {
            if (ioex != null) {
                throw ioex;
            }
            if (saxex != null) {
                throw saxex;
            }
        }
        return source;
    }

    @Override
    public final InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source;
        SAXException saxex = null;
        IOException ioex = null;
        try {
            source = this.firstResolver.resolveEntity(publicId, systemId);
        }
        catch (SAXException e) {
            saxex = e;
            source = null;
        }
        catch (IOException e) {
            ioex = e;
            source = null;
        }
        if (source == null && (source = this.fallbackResolver.resolveEntity(publicId, systemId)) == null) {
            if (ioex != null) {
                throw ioex;
            }
            if (saxex != null) {
                throw saxex;
            }
        }
        return source;
    }
}

