/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.FontVariantBuilder;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import java.util.Locale;
import java.util.Set;

class FontBuilder
extends ShorthandBuilder {
    private boolean fontVariantDone = false;

    FontBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("font", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 17;
    }

    @Override
    protected void preprocessSet() {
        this.addPropertyIfAssigned("font-variant-caps");
        this.addPropertyIfAssigned("font-variant-ligatures");
        this.addPropertyIfAssigned("font-variant-position");
        this.addPropertyIfAssigned("font-variant-numeric");
        this.addPropertyIfAssigned("font-variant-alternates");
        this.addPropertyIfAssigned("font-variant-east-asian");
    }

    private void addPropertyIfAssigned(String property) {
        BaseCSSStyleDeclaration style = this.getParentStyle();
        if (style.isPropertySet(property) && !this.isPropertyInAnySet(property)) {
            this.addAssignedProperty(property, style.isPropertyImportant(property));
        }
    }

    @Override
    boolean isInheritedProperty() {
        return true;
    }

    private void appendFontLonghand(StringBuilder buf, String property) {
        buf.append(property).append(':').append(this.getCSSValue(property).getMinifiedCssText(property));
        this.appendPriority(buf, this.isPropertyInImportantSet(property));
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        int result = this.appendFontShorthandSet(buf, declaredSet, important);
        if (result == -1) {
            return 1;
        }
        if (result == 0) {
            if (!this.fontVariantDone) {
                FontVariantBuilder builder = this.createFontVariantBuilder();
                if (builder.checkValuesForType(CSSValue.Type.INTERNAL, important) != 0) {
                    return 1;
                }
                if (!this.isFontVariantSetToInitialOrCss21(declaredSet)) {
                    builder.appendMinifiedCssText(buf);
                    this.setFontVariantDone();
                }
            }
            StyleValue vFontStretch = this.getCSSValue("font-stretch");
            if (this.isPropertyAssigned("font-stretch", important) && this.isNotInitialValue(vFontStretch, "font-stretch") && !this.isFontStretchCss3(vFontStretch)) {
                buf.append("font-stretch:").append(vFontStretch.getMinifiedCssText("font-stretch"));
                this.appendPriority(buf, this.isPropertyInImportantSet("font-stretch"));
            }
            if (this.isPropertyAssigned("font-kerning", important) && !this.isInitialValue("font-kerning")) {
                this.appendFontLonghand(buf, "font-kerning");
            }
            if (this.isPropertyAssigned("font-optical-sizing", important) && !this.isInitialValue("font-optical-sizing")) {
                this.appendFontLonghand(buf, "font-optical-sizing");
            }
            if (this.isPropertyAssigned("font-feature-settings", important) && !this.isInitialValue("font-feature-settings")) {
                this.appendFontLonghand(buf, "font-feature-settings");
            }
            if (this.isPropertyAssigned("font-variation-settings", important) && !this.isInitialValue("font-variation-settings")) {
                this.appendFontLonghand(buf, "font-variation-settings");
            }
            if (this.isPropertyAssigned("font-size-adjust", important) && !this.isInitialValue("font-size-adjust")) {
                this.appendFontLonghand(buf, "font-size-adjust");
            }
        } else {
            CSSValue.Type keyword;
            switch (result) {
                case 1: {
                    keyword = CSSValue.Type.INHERIT;
                    break;
                }
                case 2: {
                    keyword = CSSValue.Type.UNSET;
                    break;
                }
                default: {
                    keyword = CSSValue.Type.REVERT;
                }
            }
            this.appendLonghandIfNotKeyword(buf, "font-kerning", keyword, important);
            this.appendLonghandIfNotKeyword(buf, "font-optical-sizing", keyword, important);
            this.appendLonghandIfNotKeyword(buf, "font-feature-settings", keyword, important);
            this.appendLonghandIfNotKeyword(buf, "font-variation-settings", keyword, important);
            this.appendLonghandIfNotKeyword(buf, "font-size-adjust", keyword, important);
            FontVariantBuilder builder = this.createFontVariantBuilder();
            builder.preprocessSet();
            if (builder.checkValuesForType(CSSValue.Type.INTERNAL, important) != 0) {
                return 1;
            }
            byte fvTypes = builder.checkValuesForType(keyword, important);
            if (fvTypes == 2) {
                return 1;
            }
            if (fvTypes == 0 && !this.fontVariantDone && !this.isFontVariantSetToInitialOrCss21(declaredSet)) {
                builder.appendMinifiedCssText(buf);
                this.setFontVariantDone();
            }
        }
        return 0;
    }

    private int appendFontShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        buf.append(this.getShorthandName()).append(':');
        StyleValue vFontVariantCaps = this.getCSSValue("font-variant-caps");
        StyleValue vFontStyle = this.getCSSValue("font-style");
        StyleValue vFontWeight = this.getCSSValue("font-weight");
        StyleValue vFontStretch = this.getCSSValue("font-stretch");
        StyleValue vFontSize = this.getCSSValue("font-size");
        StyleValue vFontFamily = this.getCSSValue("font-family");
        StyleValue vLineHeight = this.getCSSValue("line-height");
        if (declaredSet.size() >= 7) {
            byte inheritcheck = this.checkValuesForInherit(vFontVariantCaps, vFontStyle, vFontWeight, vFontStretch, vFontSize, vFontFamily, vLineHeight);
            if (inheritcheck == 1) {
                buf.append("inherit");
                this.appendPriority(buf, important);
                return 1;
            }
            if (inheritcheck == 2) {
                return -1;
            }
            if (this.checkValuesForInitial(vFontStyle, vFontVariantCaps, vFontWeight, vFontStretch, vFontSize, vFontFamily, vLineHeight)) {
                buf.append("normal");
                this.appendPriority(buf, important);
                return 0;
            }
            byte kwcheck = this.checkValuesForKeyword(CSSValue.Type.UNSET, vFontVariantCaps, vFontStyle, vFontWeight, vFontStretch, vFontSize, vFontFamily, vLineHeight);
            if (kwcheck == 1) {
                buf.append("unset");
                this.appendPriority(buf, important);
                return 2;
            }
            if (kwcheck == 2) {
                return -1;
            }
            kwcheck = this.checkValuesForKeyword(CSSValue.Type.REVERT, vFontVariantCaps, vFontStyle, vFontWeight, vFontStretch, vFontSize, vFontFamily, vLineHeight);
            if (kwcheck == 1) {
                buf.append("revert");
                this.appendPriority(buf, important);
                return 3;
            }
            if (kwcheck == 2) {
                return -1;
            }
        }
        boolean appended = false;
        if (declaredSet.contains("font-style")) {
            appended = this.appendValueIfNotInitial(buf, "font-style", vFontStyle, appended);
        }
        if (declaredSet.contains("font-variant-caps") && this.isFontVariantCss21(vFontVariantCaps)) {
            appended = this.appendValueIfNotInitial(buf, "font-variant-caps", vFontVariantCaps, appended);
        }
        if (declaredSet.contains("font-weight")) {
            appended = this.appendValueIfNotInitial(buf, "font-weight", vFontWeight, appended);
        }
        if (declaredSet.contains("font-size") || declaredSet.contains("line-height") || declaredSet.contains("font-family") || declaredSet.contains("font-stretch")) {
            boolean not_initial_ff;
            boolean not_initial_lh = this.isNotInitialValue(vLineHeight, "line-height");
            boolean not_initial_fsz = this.isNotInitialValue(vFontSize, "font-size");
            boolean not_initial_fst = this.isNotInitialValue(vFontStretch, "font-stretch") && this.isFontStretchCss3(vFontStretch);
            boolean bl = not_initial_ff = !vFontFamily.isSystemDefault() && !this.isEffectiveInitialKeyword(vFontFamily);
            if (not_initial_fsz || not_initial_lh || not_initial_fst) {
                String fontSizeText = not_initial_fsz ? vFontSize.getMinifiedCssText("font-size") : "medium";
                if (!not_initial_ff) {
                    if (!appended) {
                        buf.append("normal");
                    }
                    this.appendPriority(buf, important);
                    if (not_initial_fst && declaredSet.contains("font-stretch")) {
                        buf.append("font-stretch:");
                        buf.append(vFontStretch.getMinifiedCssText("font-stretch"));
                        this.appendPriority(buf, important);
                    }
                    if (not_initial_fsz && declaredSet.contains("font-size")) {
                        buf.append("font-size:");
                        buf.append(fontSizeText);
                        this.appendPriority(buf, important);
                    }
                    if (not_initial_lh && declaredSet.contains("line-height")) {
                        buf.append("line-height:");
                        buf.append(vLineHeight.getMinifiedCssText("line-height"));
                        this.appendPriority(buf, important);
                    }
                    return 0;
                }
                if (not_initial_fst && declaredSet.contains("font-stretch")) {
                    appended = this.appendValueIfNotInitial(buf, "font-stretch", vFontStretch, appended);
                }
                if (appended) {
                    buf.append(' ');
                } else {
                    appended = true;
                }
                buf.append(fontSizeText);
                if (not_initial_lh) {
                    buf.append('/').append(vLineHeight.getMinifiedCssText("line-height"));
                }
                buf.append(' ');
                buf.append(vFontFamily.getMinifiedCssText("font-family"));
            } else if (not_initial_ff) {
                if (!appended) {
                    buf.append("normal");
                }
                this.appendPriority(buf, important);
                buf.append("font-family:");
                buf.append(vFontFamily.getMinifiedCssText("font-family"));
                this.appendPriority(buf, important);
                return 0;
            }
        }
        if (!appended) {
            buf.append("normal");
        }
        this.appendPriority(buf, important);
        return 0;
    }

    private boolean appendValueIfNotInitial(StringBuilder buf, String propertyName, StyleValue cssVal, boolean appended) {
        String text = this.getValueTextIfNotInitial(propertyName, cssVal);
        if (text != null) {
            if (appended) {
                buf.append(' ');
            }
            buf.append(text);
            return true;
        }
        return appended;
    }

    private void appendLonghandIfNotKeyword(StringBuilder buf, String property, CSSValue.Type keyword, boolean important) {
        StyleValue vLonghand = this.getCSSValue(property);
        if (vLonghand.getPrimitiveType() != keyword && this.isPropertyAssigned(property, important)) {
            buf.append(property).append(':');
            buf.append(vLonghand.getMinifiedCssText(property));
            this.appendPriority(buf, important);
        }
    }

    private byte checkValuesForInherit(StyleValue vFontVariantCaps, StyleValue vFontStyle, StyleValue vFontWeight, StyleValue vFontStretch, StyleValue vFontSize, StyleValue vFontFamily, StyleValue vLineHeight) {
        int count = 0;
        if (this.isInherit(vFontVariantCaps)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(vFontStyle)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(vFontWeight)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(vFontStretch)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(vFontSize)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(vFontFamily)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(vLineHeight)) {
            count = (byte)(count + 1);
        }
        switch (count) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private byte checkValuesForKeyword(CSSValue.Type keyword, StyleValue vFontVariantCaps, StyleValue vFontStyle, StyleValue vFontWeight, StyleValue vFontStretch, StyleValue vFontSize, StyleValue vFontFamily, StyleValue vLineHeight) {
        int ucount = 0;
        if (FontBuilder.isCssValueOfType(keyword, vFontVariantCaps)) {
            ucount = (byte)(ucount + 1);
        }
        if (FontBuilder.isCssValueOfType(keyword, vFontStyle)) {
            ucount = (byte)(ucount + 1);
        }
        if (FontBuilder.isCssValueOfType(keyword, vFontWeight)) {
            ucount = (byte)(ucount + 1);
        }
        if (FontBuilder.isCssValueOfType(keyword, vFontStretch)) {
            ucount = (byte)(ucount + 1);
        }
        if (FontBuilder.isCssValueOfType(keyword, vFontSize)) {
            ucount = (byte)(ucount + 1);
        }
        if (FontBuilder.isCssValueOfType(keyword, vFontFamily)) {
            ucount = (byte)(ucount + 1);
        }
        if (FontBuilder.isCssValueOfType(keyword, vLineHeight)) {
            ucount = (byte)(ucount + 1);
        }
        switch (ucount) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private boolean checkValuesForInitial(StyleValue vFontStyle, StyleValue vFontVariant, StyleValue vFontWeight, StyleValue vFontStretch, StyleValue vFontSize, StyleValue vFontFamily, StyleValue vLineHeight) {
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, vFontStyle) && this.isNotInitialValue(vFontStyle, "font-style")) {
            return false;
        }
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, vFontVariant) && this.isNotInitialValue(vFontVariant, "font-variant")) {
            return false;
        }
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, vFontWeight) && this.isNotInitialValue(vFontWeight, "font-weight")) {
            return false;
        }
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, vFontStretch) && this.isNotInitialValue(vFontStretch, "font-stretch")) {
            return false;
        }
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, vFontSize) && this.isNotInitialValue(vFontSize, "font-size")) {
            return false;
        }
        if (!FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, vFontFamily) && this.isNotInitialValue(vFontFamily, "font-family")) {
            return false;
        }
        return FontBuilder.isCssValueOfType(CSSValue.Type.INITIAL, vLineHeight) || !this.isNotInitialValue(vLineHeight, "line-height");
    }

    private boolean isFontVariantCss21(StyleValue vFontVariant) {
        String text = vFontVariant.getCssText().toLowerCase(Locale.ROOT);
        return text.equals("normal") || text.equals("small-caps") || text.equals("initial");
    }

    private boolean isFontStretchCss3(StyleValue vFontStretch) {
        String text = vFontStretch.getCssText().toLowerCase(Locale.ROOT);
        return text.equals("normal") || text.equals("ultra-condensed") || text.equals("extra-condensed") || text.equals("condensed") || text.equals("semi-condensed") || text.equals("semi-expanded") || text.equals("expanded") || text.equals("extra-expanded") || text.equals("ultra-expanded") || text.equals("initial");
    }

    private boolean isFontVariantSetToInitialOrCss21(Set<String> declaredSet) {
        if (!declaredSet.contains("font-variant-caps")) {
            return true;
        }
        StyleValue cssVal = this.getCSSValue("font-variant-caps");
        String fvcaps = cssVal.getCssText();
        if (this.isEffectiveInitialKeyword(cssVal) || fvcaps.equalsIgnoreCase("normal") || fvcaps.equalsIgnoreCase("small-caps")) {
            return !(declaredSet.contains("font-variant-ligatures") && !this.isInitialValue("font-variant-ligatures") || declaredSet.contains("font-variant-position") && !this.isInitialValue("font-variant-position") || declaredSet.contains("font-variant-numeric") && !this.isInitialValue("font-variant-numeric") || declaredSet.contains("font-variant-alternates") && !this.isInitialValue("font-variant-alternates") || declaredSet.contains("font-variant-east-asian") && !this.isInitialValue("font-variant-east-asian"));
        }
        return false;
    }

    private FontVariantBuilder createFontVariantBuilder() {
        BaseCSSStyleDeclaration style = this.getParentStyle();
        FontVariantBuilder builder = new FontVariantBuilder(style);
        this.addPropertyIfAssigned(builder, "font-variant-ligatures");
        this.addPropertyIfAssigned(builder, "font-variant-caps");
        this.addPropertyIfAssigned(builder, "font-variant-position");
        this.addPropertyIfAssigned(builder, "font-variant-numeric");
        this.addPropertyIfAssigned(builder, "font-variant-alternates");
        this.addPropertyIfAssigned(builder, "font-variant-east-asian");
        return builder;
    }

    private void setFontVariantDone() {
        this.fontVariantDone = true;
        this.removeAssignedProperty("font-variant-ligatures");
        this.removeAssignedProperty("font-variant-caps");
        this.removeAssignedProperty("font-variant-position");
        this.removeAssignedProperty("font-variant-numeric");
        this.removeAssignedProperty("font-variant-alternates");
        this.removeAssignedProperty("font-variant-east-asian");
    }

    private void addPropertyIfAssigned(ShorthandBuilder builder, String property) {
        BaseCSSStyleDeclaration style = this.getParentStyle();
        if (style.isPropertySet(property)) {
            builder.addAssignedProperty(property, style.isPropertyImportant(property));
        }
    }
}

