/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import java.util.Set;

class SequenceShorthandBuilder
extends ShorthandBuilder {
    SequenceShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle) {
        super(shorthandName, parentStyle);
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        String[] subp;
        if (this.hasPropertiesToExclude(declaredSet)) {
            return 1;
        }
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        if (this.isInheritedProperty()) {
            check = this.checkValuesForType(CSSValue.Type.UNSET, declaredSet);
            if (check == 1) {
                buf.append("unset");
                this.appendPriority(buf, important);
                return 0;
            }
            if (check == 2) {
                return 1;
            }
        }
        if ((check = this.checkValuesForType(CSSValue.Type.REVERT, declaredSet)) == 1) {
            buf.append("revert");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        if (this.checkValuesForType(CSSValue.Type.INTERNAL, declaredSet) != 0) {
            return 1;
        }
        for (String property : subp = this.getSubproperties()) {
            StyleValue cssVal;
            if (!declaredSet.contains(property) || (cssVal = this.getCSSValue(property)).getCssValueType() != CSSValue.CssType.LIST) continue;
            return 1;
        }
        boolean appended = false;
        StyleValue cssVal0 = null;
        if (declaredSet.contains(subp[0])) {
            cssVal0 = this.getCSSValue(subp[0]);
            if (!this.isNotInitialValue(cssVal0, subp[0])) {
                cssVal0 = this.getInitialPropertyValue(subp[0]);
            }
            String text = cssVal0.getMinifiedCssText(subp[0]);
            buf.append(text);
            appended = true;
        }
        if (declaredSet.contains(subp[1])) {
            StyleValue cssVal1 = this.getCSSValue(subp[1]);
            if (!this.isNotInitialValue(cssVal1, subp[1])) {
                cssVal1 = this.getInitialPropertyValue(subp[1]);
            }
            if (!this.valueEquals(cssVal0, cssVal1)) {
                if (appended) {
                    buf.append(' ');
                }
                buf.append(cssVal1.getMinifiedCssText(subp[1]));
            }
        }
        this.appendPriority(buf, important);
        return 0;
    }
}

