/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.BooleanConditionHelper;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

abstract class BooleanConditionUnit
extends LexicalUnitImpl
implements BooleanCondition {
    private static final long serialVersionUID = 1L;
    private BooleanCondition parent = null;

    BooleanConditionUnit(LexicalUnit.LexicalType unitType) {
        super(unitType);
    }

    @Override
    public List<BooleanCondition> getSubConditions() {
        return null;
    }

    @Override
    public BooleanCondition getNestedCondition() {
        return null;
    }

    @Override
    public BooleanCondition getParentCondition() {
        return this.parent;
    }

    @Override
    public void setParentCondition(BooleanCondition parent) {
        this.parent = parent;
    }

    @Override
    public abstract void addCondition(BooleanCondition var1);

    @Override
    public abstract BooleanCondition replaceLast(BooleanCondition var1);

    @Override
    public abstract void appendText(StringBuilder var1);

    @Override
    String currentToString() {
        return this.getCssText();
    }

    @Override
    public String getCssText() {
        StringBuilder buf = new StringBuilder(32);
        this.appendText(buf);
        return buf.toString();
    }

    static class FalseCondition
    extends BooleanConditionUnit {
        private static final long serialVersionUID = 1L;
        private final String condition;

        public FalseCondition(LexicalUnit.LexicalType unitType, String condition) {
            super(unitType);
            this.condition = condition;
        }

        @Override
        public BooleanCondition.Type getType() {
            return BooleanCondition.Type.OTHER;
        }

        @Override
        public void addCondition(BooleanCondition nestedCondition) {
        }

        @Override
        public BooleanCondition replaceLast(BooleanCondition newCondition) {
            return this;
        }

        @Override
        public void appendText(StringBuilder buf) {
            buf.append(this.condition);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.condition);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FalseCondition other = (FalseCondition)obj;
            return Objects.equals(this.condition, other.condition);
        }
    }

    static class Predicate
    extends BooleanConditionUnit {
        private static final long serialVersionUID = 2L;
        private final String name;

        Predicate(String name) {
            super(LexicalUnit.LexicalType.CONDITION_PREDICATE);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public BooleanCondition.Type getType() {
            return BooleanCondition.Type.PREDICATE;
        }

        public int getPredicateType() {
            return 0;
        }

        @Override
        public void addCondition(BooleanCondition nestedCondition) {
        }

        @Override
        public BooleanCondition replaceLast(BooleanCondition newCondition) {
            return this;
        }

        @Override
        public void appendText(StringBuilder buf) {
            buf.append(this.name);
        }

        @Override
        public String getCssText() {
            return this.name;
        }

        @Override
        LexicalUnitImpl instantiateLexicalUnit() {
            return new Predicate(this.name);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.name);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Predicate other = (Predicate)obj;
            return Objects.equals(this.name, other.name);
        }
    }

    static class NotCondition
    extends BooleanConditionUnit {
        private static final long serialVersionUID = 1L;
        BooleanCondition nestedCondition;

        NotCondition() {
            super(LexicalUnit.LexicalType.CONDITION_NOT);
        }

        @Override
        public void addCondition(BooleanCondition nestedCondition) {
            nestedCondition.setParentCondition(this);
            this.nestedCondition = nestedCondition;
        }

        @Override
        public BooleanCondition replaceLast(BooleanCondition newCondition) {
            BooleanCondition last = this.nestedCondition;
            this.addCondition(newCondition);
            return last;
        }

        @Override
        public BooleanCondition.Type getType() {
            return BooleanCondition.Type.NOT;
        }

        @Override
        public BooleanCondition getNestedCondition() {
            return this.nestedCondition;
        }

        @Override
        public void appendText(StringBuilder buf) {
            BooleanConditionHelper.appendNOTText(this, buf);
        }

        @Override
        public void appendMinifiedText(StringBuilder buf) {
            BooleanConditionHelper.appendNOTMinifiedText(this, buf);
        }

        @Override
        NotCondition instantiateLexicalUnit() {
            return new NotCondition();
        }

        @Override
        public NotCondition shallowClone() {
            NotCondition clon = (NotCondition)super.shallowClone();
            clon.nestedCondition = this.nestedCondition;
            return clon;
        }

        @Override
        public int hashCode() {
            return this.nestedCondition == null ? 0 : this.nestedCondition.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotCondition other = (NotCondition)obj;
            return !(this.nestedCondition == null ? other.nestedCondition != null : !this.nestedCondition.equals(other.nestedCondition));
        }
    }

    static class OrCondition
    extends GroupCondition {
        private static final long serialVersionUID = 1L;

        OrCondition() {
            super(LexicalUnit.LexicalType.CONDITION_OR);
        }

        @Override
        public BooleanCondition.Type getType() {
            return BooleanCondition.Type.OR;
        }

        @Override
        LexicalUnitImpl instantiateLexicalUnit() {
            return new OrCondition();
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + 7;
        }

        @Override
        public void appendText(StringBuilder buf) {
            BooleanConditionHelper.appendORText(this, buf);
        }

        @Override
        public void appendMinifiedText(StringBuilder buf) {
            BooleanConditionHelper.appendORMinifiedText(this, buf);
        }
    }

    static class AndCondition
    extends GroupCondition {
        private static final long serialVersionUID = 1L;

        AndCondition() {
            super(LexicalUnit.LexicalType.CONDITION_AND);
            this.nestedConditions = new LinkedList();
        }

        @Override
        public BooleanCondition.Type getType() {
            return BooleanCondition.Type.AND;
        }

        @Override
        public void appendText(StringBuilder buf) {
            BooleanConditionHelper.appendANDText(this, buf);
        }

        @Override
        public void appendMinifiedText(StringBuilder buf) {
            BooleanConditionHelper.appendANDMinifiedText(this, buf);
        }

        @Override
        LexicalUnitImpl instantiateLexicalUnit() {
            return new AndCondition();
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + 13;
        }
    }

    static abstract class GroupCondition
    extends BooleanConditionUnit {
        private static final long serialVersionUID = 1L;
        LinkedList<BooleanCondition> nestedConditions = new LinkedList();

        GroupCondition(LexicalUnit.LexicalType unitType) {
            super(unitType);
        }

        @Override
        public void addCondition(BooleanCondition condition) {
            condition.setParentCondition(this);
            this.nestedConditions.add(condition);
        }

        @Override
        public BooleanCondition replaceLast(BooleanCondition newCondition) {
            BooleanCondition last = this.nestedConditions.removeLast();
            last.setParentCondition(null);
            this.addCondition(newCondition);
            return last;
        }

        @Override
        public List<BooleanCondition> getSubConditions() {
            return this.nestedConditions;
        }

        @Override
        public GroupCondition shallowClone() {
            GroupCondition clon = (GroupCondition)super.shallowClone();
            clon.nestedConditions = this.nestedConditions;
            return clon;
        }

        @Override
        public int hashCode() {
            return this.nestedConditions == null ? 0 : this.nestedConditions.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupCondition other = (GroupCondition)obj;
            return !(this.nestedConditions == null ? other.nestedConditions != null : !this.nestedConditions.equals(other.nestedConditions));
        }
    }
}

