/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.UnicodeUnitImpl;

class UnicodeRangeUnitImpl
extends UnicodeUnitImpl {
    private static final long serialVersionUID = 1L;

    public UnicodeRangeUnitImpl() {
        super(LexicalUnit.LexicalType.UNICODE_RANGE);
    }

    @Override
    public LexicalUnit getSubValues() {
        return this.parameters;
    }

    @Override
    CharSequence currentToString() {
        StringBuilder buf = new StringBuilder();
        LexicalUnit lu = this.parameters;
        if (lu != null) {
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
                buf.append("U+").append(Integer.toHexString(lu.getIntegerValue()));
            } else {
                buf.append("U+").append(lu.getStringValue());
            }
            lu = lu.getNextLexicalUnit();
            if (lu != null) {
                buf.append('-');
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
                    buf.append(Integer.toHexString(lu.getIntegerValue()));
                } else {
                    buf.append(lu.getStringValue());
                }
            }
        }
        return buf;
    }

    @Override
    UnicodeRangeUnitImpl instantiateLexicalUnit() {
        return new UnicodeRangeUnitImpl();
    }
}

