/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LCHColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorImpl;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class LCHColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.LCHColorValue {
    private static final long serialVersionUID = 2L;
    private final LCHColorImpl lchColor;

    public LCHColorValue() {
        this(new LCHColorImpl(BaseColor.Space.CIE_LCh, "lch"));
    }

    LCHColorValue(LCHColorImpl color) {
        this.lchColor = color;
    }

    LCHColorValue(LCHColorValue copied) {
        super(copied);
        this.lchColor = copied.lchColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LCH;
    }

    @Override
    void set(StyleValue value) {
        super.set(value);
        LCHColorValue setfrom = (LCHColorValue)value;
        this.lchColor.set(setfrom.lchColor);
    }

    @Override
    public String getCssText() {
        return this.lchColor.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyValue) {
        return this.lchColor.toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        this.lchColor.writeCssText(wri);
    }

    @Override
    public PrimitiveValue getComponent(int index) {
        return this.lchColor.item(index);
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        this.lchColor.setComponent(index, (PrimitiveValue)component);
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean clamp) throws DOMException {
        double[] rgb = this.lchColor.toSRGB(clamp);
        ColorValue.CSSRGBColor color = new ColorValue.CSSRGBColor();
        color.setColorComponents(rgb);
        color.setAlpha(this.lchColor.getAlpha().clone());
        return color;
    }

    @Override
    public LABColorValue toLABColorValue() throws DOMException {
        float h;
        if (!this.lchColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        CSSTypedValue primihue = (CSSTypedValue)((Object)this.lchColor.getHue());
        float c = ((CSSTypedValue)((Object)this.lchColor.getChroma())).getFloatValue((short)0);
        short unit = primihue.getUnitType();
        if (unit == 0) {
            h = primihue.getFloatValue();
            h = NumberValue.floatValueConversion(h, (short)80, (short)81);
        } else {
            h = primihue.getFloatValue((short)81);
        }
        float a = (float)((double)c * Math.cos(h));
        float b = (float)((double)c * Math.sin(h));
        NumberValue primia = NumberValue.createCSSNumberValue((short)0, a);
        NumberValue primib = NumberValue.createCSSNumberValue((short)0, b);
        primia.setAbsolutizedUnit();
        primib.setAbsolutizedUnit();
        LABColorValue lab = new LABColorValue();
        lab.setComponent(0, this.lchColor.getAlpha().clone());
        lab.setComponent(1, this.lchColor.getLightness().clone());
        lab.setComponent(2, primia);
        lab.setComponent(3, primib);
        return lab;
    }

    @Override
    public LCHColorValue toLCHColorValue() throws DOMException {
        return this;
    }

    @Override
    public LCHColor getColor() {
        return this.lchColor;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.lchColor.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue color) {
        LCHColor lch;
        if (!this.lchColor.hasConvertibleComponents() || !((ColorValue)color).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (color.getColorModel()) {
            case LCH: {
                lch = (LCHColor)color.getColor();
                if (!"oklch".equals(lch.getColorSpace())) break;
                lch = color.toLCHColorValue().getColor();
                break;
            }
            case LAB: {
                lch = color.toLCHColorValue().getColor();
                break;
            }
            case RGB: {
                RGBColor rgbcolor = (RGBColor)color.getColor();
                LABColorValue lab = new LABColorValue();
                rgbcolor.toLABColor(lab.getLABColorImpl());
                lch = lab.toLCHColorValue().getColor();
                break;
            }
            case XYZ: {
                XYZColorImpl xyz = (XYZColorImpl)color.getColor();
                LABColorValue lab = new LABColorValue();
                xyz.toLABColor(lab.getLABColorImpl());
                lch = lab.toLCHColorValue().getColor();
                break;
            }
            default: {
                RGBAColor rgb = color.toRGBColor(false);
                CSSColorValue rgbValue = rgb.packInValue();
                lch = rgbValue.toLABColorValue().toLCHColorValue().getColor();
            }
        }
        return ColorUtil.deltaE2000LCh(((CSSTypedValue)((Object)this.lchColor.getLightness())).getFloatValue((short)0), ((CSSTypedValue)((Object)this.lchColor.getChroma())).getFloatValue((short)0), ColorUtil.hueRadians((CSSTypedValue)((Object)this.lchColor.getHue())), ((CSSTypedValue)lch.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lch.getChroma()).getFloatValue((short)0), ColorUtil.hueRadians((CSSTypedValue)lch.getHue()));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.lchColor.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LCHColorValue other = (LCHColorValue)obj;
        return this.lchColor.equals(other.lchColor);
    }

    @Override
    public LCHColorValue clone() {
        return new LCHColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(LCHColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            try {
                if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.LCHCOLOR) {
                    throw new DOMException(13, "No lch() value: " + lunit.toString());
                }
                this.setLexicalLCH(lunit);
            }
            catch (DOMException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new DOMSyntaxException("Invalid value: " + lunit.toString());
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void setLexicalLCH(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            ValueFactory factory = new ValueFactory();
            CSSColor from = null;
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "from".equalsIgnoreCase(lu.getStringValue())) {
                PrimitiveValue fromval = factory.createCSSPrimitiveValue(lu = ColorValue.nextLexicalUnit(lu, lunit), true);
                from = ColorValue.computeColor(fromval, factory);
                String cs = from.getColorSpace();
                if (!cs.equals("lch")) {
                    from = from.toColorSpace("lch");
                }
                lu = ColorValue.nextLexicalUnit(lu, lunit);
            }
            PrimitiveValue primilight = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primilight = LCHColorValue.this.absoluteComponent(from, primilight, false);
            }
            lu = lu.getNextLexicalUnit();
            PrimitiveValue primichroma = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primichroma = LCHColorValue.this.absoluteComponent(from, primichroma, false);
            }
            lu = lu.getNextLexicalUnit();
            PrimitiveValue primihue = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primihue = ColorValue.absoluteHue(from, primihue);
            }
            if ((lu = lu.getNextLexicalUnit()) != null) {
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    throw new DOMSyntaxException("Expected slash in: " + lunit.toString());
                }
                lu = lu.getNextLexicalUnit();
                PrimitiveValue alpha = factory.createCSSPrimitiveValue(lu, true);
                if (from != null) {
                    alpha = LCHColorValue.this.absoluteComponent(from, alpha, false);
                }
                LCHColorValue.this.lchColor.setAlpha(alpha);
                lu = lu.getNextLexicalUnit();
                if (lu != null) {
                    throw new DOMSyntaxException("Invalid value: " + lunit.toString());
                }
            }
            LCHColorValue.this.lchColor.setLightness(primilight);
            LCHColorValue.this.lchColor.setChroma(primichroma);
            LCHColorValue.this.lchColor.setHue(primihue);
        }
    }
}

