/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

class OKLABColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.LABColorValue {
    private static final long serialVersionUID = 1L;
    private final LABColorImpl labColor;

    public OKLABColorValue() {
        this(new LABColorImpl(BaseColor.Space.OK_Lab, "oklab"));
    }

    OKLABColorValue(LABColorImpl color) {
        this.labColor = color;
    }

    OKLABColorValue(OKLABColorValue copied) {
        super(copied);
        this.labColor = copied.labColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LAB;
    }

    @Override
    void set(StyleValue value) {
        super.set(value);
        OKLABColorValue setfrom = (OKLABColorValue)value;
        this.labColor.set(setfrom.labColor);
    }

    @Override
    public String getCssText() {
        return this.labColor.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyValue) {
        return this.labColor.toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        this.labColor.writeCssText(wri);
    }

    @Override
    public PrimitiveValue getComponent(int index) {
        return this.labColor.item(index);
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        this.labColor.setComponent(index, (PrimitiveValue)component);
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean clamp) throws DOMException {
        if (!this.labColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float light = ((CSSTypedValue)((Object)this.labColor.getLightness())).getFloatValue((short)0);
        float a = ((CSSTypedValue)((Object)this.labColor.getA())).getFloatValue((short)0);
        float b = ((CSSTypedValue)((Object)this.labColor.getB())).getFloatValue((short)0);
        SRGBColorProfile profile = new SRGBColorProfile();
        double[] rgb = new double[3];
        ColorUtil.oklabToRGB(light, a, b, clamp, profile, rgb);
        ColorValue.CSSRGBColor color = new ColorValue.CSSRGBColor();
        color.setColorComponents(rgb);
        color.setAlpha(this.labColor.getAlpha().clone());
        return color;
    }

    @Override
    public LABColorValue toLABColorValue() {
        if (!this.labColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float light = ((CSSTypedValue)((Object)this.labColor.getLightness())).getFloatValue((short)0);
        float a = ((CSSTypedValue)((Object)this.labColor.getA())).getFloatValue((short)0);
        float b = ((CSSTypedValue)((Object)this.labColor.getB())).getFloatValue((short)0);
        double[] lab = new double[3];
        ColorUtil.oklabToLab(light, a, b, lab);
        NumberValue primiL = NumberValue.createCSSNumberValue((short)0, (float)lab[0]);
        NumberValue primia = NumberValue.createCSSNumberValue((short)0, (float)lab[1]);
        NumberValue primib = NumberValue.createCSSNumberValue((short)0, (float)lab[2]);
        primiL.setAbsolutizedUnit();
        primia.setAbsolutizedUnit();
        primib.setAbsolutizedUnit();
        LABColorValue primiLab = new LABColorValue();
        primiLab.setComponent(0, this.labColor.getAlpha().clone());
        primiLab.setComponent(1, primiL);
        primiLab.setComponent(2, primia);
        primiLab.setComponent(3, primib);
        return primiLab;
    }

    @Override
    public LCHColorValue toLCHColorValue() throws DOMException {
        if (!this.labColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float light = ((CSSTypedValue)((Object)this.labColor.getLightness())).getFloatValue((short)0);
        double a = ((CSSTypedValue)((Object)this.labColor.getA())).getFloatValue((short)0);
        double b = ((CSSTypedValue)((Object)this.labColor.getB())).getFloatValue((short)0);
        double[] lab = new double[3];
        ColorUtil.oklabToLab(light, a, b, lab);
        a = lab[1];
        b = lab[2];
        double c = Math.sqrt(a * a + b * b);
        double h = Math.atan2(b, a) * 180.0 / Math.PI;
        if (h < 0.0) {
            h += 360.0;
        }
        NumberValue primiL = NumberValue.createCSSNumberValue((short)0, (float)lab[0]);
        NumberValue chroma = NumberValue.createCSSNumberValue((short)0, (float)c);
        NumberValue hue = NumberValue.createCSSNumberValue((short)80, (float)h);
        primiL.setAbsolutizedUnit();
        chroma.setAbsolutizedUnit();
        hue.setAbsolutizedUnit();
        LCHColorValue lch = new LCHColorValue();
        lch.setComponent(0, this.labColor.getAlpha().clone());
        lch.setComponent(1, primiL);
        lch.setComponent(2, chroma);
        lch.setComponent(3, hue);
        return lch;
    }

    @Override
    public LABColor getColor() {
        return this.labColor;
    }

    LABColorImpl getLABColorImpl() {
        return this.labColor;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.labColor.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue color) {
        LABColor lab;
        if (!this.labColor.hasConvertibleComponents() || !((ColorValue)color).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (color.getColorModel()) {
            case LAB: {
                lab = (LABColor)color.getColor();
                if (!"oklab".equals(lab.getColorSpace())) break;
                lab = color.toLABColorValue().getColor();
                break;
            }
            case LCH: {
                lab = color.toLABColorValue().getColor();
                break;
            }
            case RGB: {
                RGBColor rgbcolor = (RGBColor)color.getColor();
                LABColorImpl labColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                rgbcolor.toLABColor(labColor);
                lab = labColor;
                break;
            }
            case XYZ: {
                XYZColorImpl xyz = (XYZColorImpl)color.getColor();
                LABColorImpl labColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                xyz.toLABColor(labColor);
                lab = labColor;
                break;
            }
            default: {
                RGBAColor rgb = color.toRGBColor(false);
                CSSColorValue rgbValue = rgb.packInValue();
                lab = rgbValue.toLABColorValue().getColor();
            }
        }
        LABColor thislab = this.toLABColorValue().getColor();
        return ColorUtil.deltaE2000Lab(((CSSTypedValue)thislab.getLightness()).getFloatValue((short)0), ((CSSTypedValue)thislab.getA()).getFloatValue((short)0), ((CSSTypedValue)thislab.getB()).getFloatValue((short)0), ((CSSTypedValue)lab.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lab.getA()).getFloatValue((short)0), ((CSSTypedValue)lab.getB()).getFloatValue((short)0));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.labColor.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OKLABColorValue other = (OKLABColorValue)obj;
        return this.labColor.equals(other.labColor);
    }

    @Override
    public OKLABColorValue clone() {
        return new OKLABColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(OKLABColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            try {
                if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.OKLABCOLOR) {
                    throw new DOMException(13, "No oklab() value: " + lunit.toString());
                }
                this.setLexicalLAB(lunit);
            }
            catch (DOMException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new DOMSyntaxException("Invalid value: " + lunit.toString());
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void setLexicalLAB(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            ValueFactory factory = new ValueFactory();
            CSSColor from = null;
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "from".equalsIgnoreCase(lu.getStringValue())) {
                PrimitiveValue fromval = factory.createCSSPrimitiveValue(lu = ColorValue.nextLexicalUnit(lu, lunit), true);
                from = ColorValue.computeColor(fromval, factory);
                String cs = from.getColorSpace();
                if (!cs.equals("oklab")) {
                    from = from.toColorSpace("oklab");
                }
                lu = ColorValue.nextLexicalUnit(lu, lunit);
            }
            PrimitiveValue primilight = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primilight = OKLABColorValue.this.absoluteComponent(from, primilight, false);
            }
            lu = lu.getNextLexicalUnit();
            PrimitiveValue primia = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primia = OKLABColorValue.this.absoluteComponent(from, primia, false);
            }
            lu = lu.getNextLexicalUnit();
            PrimitiveValue primib = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primib = OKLABColorValue.this.absoluteComponent(from, primib, false);
            }
            if ((lu = lu.getNextLexicalUnit()) != null) {
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    this.checkProxyValue(lu);
                    throw new DOMSyntaxException("Expected slash in: " + lunit.toString());
                }
                lu = lu.getNextLexicalUnit();
                PrimitiveValue alpha = factory.createCSSPrimitiveValue(lu, true);
                if (from != null) {
                    alpha = OKLABColorValue.this.absoluteComponent(from, alpha, false);
                }
                OKLABColorValue.this.labColor.setAlpha(alpha);
                lu = lu.getNextLexicalUnit();
                if (lu != null) {
                    throw new DOMSyntaxException("Invalid value: " + lunit.toString());
                }
            }
            OKLABColorValue.this.labColor.setLightness(primilight);
            OKLABColorValue.this.labColor.setA(primia);
            OKLABColorValue.this.labColor.setB(primib);
        }
    }
}

