/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math;

public final class Binary64 {
    static final long NEGATIVE_ZERO_BITS = Long.MIN_VALUE;
    static final long MASK_SIGN = Long.MIN_VALUE;
    static final long MASK_EXPONENT = 0x7FF0000000000000L;
    static final long MASK_SIGNIFICAND = 0xFFFFFFFFFFFFFL;
    static final long BIAS = 1023L;

    public static long unpackGetExponentUnbiased(double d) {
        long l = Double.doubleToRawLongBits(d);
        long l2 = l & MASK_EXPONENT;
        long l3 = l2 >> 52;
        return l3 - BIAS;
    }

    public static long unpackGetSignificand(double d) {
        long l = Double.doubleToRawLongBits(d);
        return l & MASK_SIGNIFICAND;
    }

    public static long unpackGetSign(double d) {
        long l = Double.doubleToRawLongBits(d);
        return (l & MASK_SIGN) >> 63 & 1L;
    }
}

