/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.main;

public class VTAssociationMarkupStatus
implements Comparable<VTAssociationMarkupStatus> {
    private static int INITIALIZED = 1;
    private static int HAS_UNEXAMINED = 2;
    private static int HAS_APPLIED = 4;
    private static int HAS_REJECTED = 8;
    private static int HAS_DONT_CARE = 16;
    private static int HAS_DONT_KNOW = 32;
    private static int HAS_ERRORS = 64;
    private int status;

    public VTAssociationMarkupStatus() {
        this.status = 0;
    }

    public VTAssociationMarkupStatus(int status) {
        this.status = status;
    }

    public VTAssociationMarkupStatus(boolean hasUnexamined, boolean hasApplied, boolean hasRejected, boolean hasDontCare, boolean hasDontKnow, boolean hasErrors) {
        this.status = INITIALIZED;
        this.status |= hasUnexamined ? HAS_UNEXAMINED : 0;
        this.status |= hasApplied ? HAS_APPLIED : 0;
        this.status |= hasRejected ? HAS_REJECTED : 0;
        this.status |= hasDontCare ? HAS_DONT_CARE : 0;
        this.status |= hasDontKnow ? HAS_DONT_KNOW : 0;
        this.status |= hasErrors ? HAS_ERRORS : 0;
    }

    public boolean isInitialized() {
        return (this.status & INITIALIZED) != 0;
    }

    public boolean hasUnexaminedMarkup() {
        return (this.status & HAS_UNEXAMINED) != 0;
    }

    public boolean hasAppliedMarkup() {
        return (this.status & HAS_APPLIED) != 0;
    }

    public boolean hasRejectedMarkup() {
        return (this.status & HAS_REJECTED) != 0;
    }

    public boolean hasDontCareMarkup() {
        return (this.status & HAS_DONT_CARE) != 0;
    }

    public boolean hasDontKnowMarkup() {
        return (this.status & HAS_DONT_KNOW) != 0;
    }

    public boolean hasErrors() {
        return (this.status & HAS_ERRORS) != 0;
    }

    public int getStatusValue() {
        return this.status;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VTAssociationMarkupStatus)) {
            return false;
        }
        return this.status == ((VTAssociationMarkupStatus)obj).status;
    }

    public int hashCode() {
        return this.status;
    }

    public boolean isFullyApplied() {
        return this.status == INITIALIZED || this.status == (INITIALIZED | HAS_APPLIED);
    }

    @Override
    public int compareTo(VTAssociationMarkupStatus o) {
        return this.status - o.status;
    }

    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        if (this.hasUnexaminedMarkup()) {
            buf.append("Has one or more unexamined markup items.\n");
        }
        if (this.hasAppliedMarkup()) {
            buf.append("Has one or more applied markup items.\n");
        }
        if (this.hasErrors()) {
            buf.append("Has one or more markup items that failed to apply.\n");
        }
        if (this.hasDontCareMarkup()) {
            buf.append("Has one or more \"Don't Care\" markup items.\n");
        }
        if (this.hasDontKnowMarkup()) {
            buf.append("Has one or more \"Don't Know\" markup items.\n");
        }
        return buf.toString();
    }

    public String toString() {
        return "Markup Status: " + this.getDescription();
    }
}

