/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Accumulator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SynchronizedListAccumulator<T>
implements Accumulator<T> {
    private List<T> list;

    public SynchronizedListAccumulator() {
        this.list = new ArrayList<T>();
    }

    public SynchronizedListAccumulator(List<T> list) {
        this.list = new ArrayList<T>(list);
    }

    @Override
    public synchronized void add(T t) {
        this.list.add(t);
    }

    @Override
    public synchronized void addAll(Collection<T> collection) {
        this.list.addAll(collection);
    }

    @Override
    public synchronized boolean contains(T t) {
        return this.list.contains(t);
    }

    @Override
    public synchronized Collection<T> get() {
        return new ArrayList<T>(this.list);
    }

    public synchronized List<T> asList() {
        return new ArrayList<T>(this.list);
    }

    @Override
    public synchronized int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return this.asList().iterator();
    }

    public synchronized String toString() {
        return this.list.toString();
    }
}

