/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.quickmethod;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader;
import ghidra.file.formats.android.oat.quickmethod.QuickMethodFrameInfo;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class OatQuickMethodHeader_Oreo
extends OatQuickMethodHeader {
    static final int SIZE = 28;
    private int vmap_table_offset_;
    private int method_info_offset_;
    private QuickMethodFrameInfo frame_info_;
    private int code_size_;
    private byte[] code_;

    OatQuickMethodHeader_Oreo(BinaryReader reader) throws IOException {
        this.vmap_table_offset_ = reader.readNextInt();
        this.method_info_offset_ = reader.readNextInt();
        this.frame_info_ = new QuickMethodFrameInfo(reader);
        this.code_size_ = reader.readNextInt();
        this.code_ = reader.readNextByteArray(this.code_size_);
    }

    public int getVmapTableOffset() {
        return this.vmap_table_offset_;
    }

    public int getMethodInfoOffset() {
        return this.method_info_offset_;
    }

    public QuickMethodFrameInfo getFrameInfo() {
        return this.frame_info_;
    }

    @Override
    public int getCodeSize() {
        return this.code_size_;
    }

    public byte[] getCode() {
        return this.code_;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(OatQuickMethodHeader_Oreo.class.getSimpleName(), 0);
        structure.add(DWORD, "vmap_table_offset_", null);
        structure.add(DWORD, "method_info_offset_", null);
        structure.add(this.frame_info_.toDataType(), "frame_info_", null);
        structure.add(DWORD, "code_size_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

