/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashBasicFileInode;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import java.io.IOException;

public class SquashExtendedFileInode
extends SquashBasicFileInode {
    private long sparseCount;
    private long linkCount;
    private long xattrIndex;

    public SquashExtendedFileInode(BinaryReader reader, SquashSuperBlock superBlock) throws IOException {
        super(reader, superBlock, true);
        this.startBlockOffset = reader.readNextLong();
        this.fileSize = reader.readNextLong();
        this.sparseCount = reader.readNextLong();
        this.linkCount = reader.readNextUnsignedInt();
        if (reader.peekNextInt() == -1) {
            this.fragmentIndex = -1;
            this.blockOffset = -1;
            reader.setPointerIndex(reader.getPointerIndex() + 8L);
        } else {
            this.fragmentIndex = reader.readNextUnsignedIntExact();
            this.blockOffset = reader.readNextUnsignedIntExact();
        }
        this.xattrIndex = reader.readNextUnsignedInt();
        this.setVars(reader, superBlock);
    }

    public long getSparseCount() {
        return this.sparseCount;
    }

    public long getLinkCount() {
        return this.linkCount;
    }

    public long getXattrIndex() {
        return this.xattrIndex;
    }
}

