/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import db.RecordIterator;
import ghidra.program.database.symbol.SymbolDatabaseAdapter;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.program.database.util.Query;
import ghidra.program.database.util.QueryRecordIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import java.io.IOException;
import java.util.Iterator;

class AddressSetFilteredSymbolIterator
implements SymbolIterator {
    private SymbolManager symbolMgr;
    private QueryRecordIterator recIter;
    private SymbolDatabaseAdapter adapter;

    AddressSetFilteredSymbolIterator(SymbolManager symbolMgr, AddressSetView set, Query query, boolean forward) {
        this.symbolMgr = symbolMgr;
        this.adapter = symbolMgr.getDatabaseAdapter();
        try {
            RecordIterator it = this.adapter.getSymbols(set, forward);
            this.recIter = new QueryRecordIterator(it, query, forward);
        }
        catch (IOException e) {
            symbolMgr.dbError(e);
            this.recIter = new QueryRecordIterator(new EmptyRecordIterator(), query, forward);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.recIter.hasNext();
        }
        catch (IOException e) {
            this.symbolMgr.dbError(e);
            return false;
        }
    }

    @Override
    public Symbol next() {
        if (this.hasNext()) {
            try {
                DBRecord rec = this.recIter.next();
                return this.symbolMgr.getSymbol(rec);
            }
            catch (IOException e) {
                this.symbolMgr.dbError(e);
            }
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Symbol> iterator() {
        return this;
    }
}

