/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.StringFormat;
import ghidra.util.classfinder.ClassTranslator;

public class Undefined2DataType
extends Undefined {
    private static final long serialVersionUID = 1L;
    public static final Undefined2DataType dataType;

    public Undefined2DataType() {
        this(null);
    }

    public Undefined2DataType(DataTypeManager dtm) {
        super("undefined2", dtm);
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public String getDescription() {
        return "Undefined Word";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    private long getValue(MemBuffer buf) throws MemoryAccessException {
        long val = buf.getShort(0);
        return val & 0xFFFFL;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        String val = "??";
        try {
            long b = this.getValue(buf);
            val = Long.toHexString(b).toUpperCase();
            val = StringFormat.padIt((String)val, (int)4, (char)'h', (boolean)true);
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return val;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            return new Scalar(16, this.getValue(buf));
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new Undefined2DataType(dtm);
    }

    static {
        ClassTranslator.put((String)"ghidra.program.model.data.Undefined2", (String)Undefined2DataType.class.getName());
        dataType = new Undefined2DataType();
    }
}

