/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockType;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

public interface MemoryBlock
extends Serializable,
Comparable<MemoryBlock> {
    public static final String EXTERNAL_BLOCK_NAME = "EXTERNAL";
    public static final int ARTIFICIAL = 16;
    public static final int VOLATILE = 8;
    public static final int READ = 4;
    public static final int WRITE = 2;
    public static final int EXECUTE = 1;

    public int getFlags();

    public InputStream getData();

    public boolean contains(Address var1);

    public Address getStart();

    public Address getEnd();

    public AddressRange getAddressRange();

    public long getSize();

    public BigInteger getSizeAsBigInteger();

    public String getName();

    public void setName(String var1) throws IllegalArgumentException, LockException;

    public String getComment();

    public void setComment(String var1);

    public boolean isRead();

    public void setRead(boolean var1);

    public boolean isWrite();

    public void setWrite(boolean var1);

    public boolean isExecute();

    public void setExecute(boolean var1);

    public void setPermissions(boolean var1, boolean var2, boolean var3);

    public boolean isVolatile();

    public void setVolatile(boolean var1);

    public boolean isArtificial();

    public void setArtificial(boolean var1);

    public String getSourceName();

    public void setSourceName(String var1);

    public byte getByte(Address var1) throws MemoryAccessException;

    public int getBytes(Address var1, byte[] var2) throws MemoryAccessException;

    public int getBytes(Address var1, byte[] var2, int var3, int var4) throws IndexOutOfBoundsException, MemoryAccessException;

    public void putByte(Address var1, byte var2) throws MemoryAccessException;

    public int putBytes(Address var1, byte[] var2) throws MemoryAccessException;

    public int putBytes(Address var1, byte[] var2, int var3, int var4) throws IndexOutOfBoundsException, MemoryAccessException;

    public MemoryBlockType getType();

    public boolean isInitialized();

    public boolean isMapped();

    default public boolean isExternalBlock() {
        return EXTERNAL_BLOCK_NAME.equals(this.getName());
    }

    public boolean isOverlay();

    public boolean isLoaded();

    public List<MemoryBlockSourceInfo> getSourceInfos();
}

