/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.DefaultActionContext;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToggleDockingActionIf;
import docking.menu.ManagedMenuItem;
import docking.menu.MenuHandler;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import resources.ResourceManager;

class MenuItemManager
implements ManagedMenuItem,
PropertyChangeListener,
ActionListener {
    private MenuHandler menuHandler;
    private DockingActionIf action;
    private boolean isPopup;
    private JMenuItem menuItem;
    private ChangeListener buttonModelChangeListener;
    private MouseAdapter menuHoverListener;

    MenuItemManager(MenuHandler actionHandler, DockingActionIf dockingAction, boolean usePopupPath) {
        this.menuHandler = actionHandler;
        this.action = dockingAction;
        this.isPopup = usePopupPath;
        this.action.addPropertyChangeListener(this);
        this.buttonModelChangeListener = this.getButtonModelChangeListener();
        this.menuHoverListener = this.getMenuHoverListener();
    }

    private MouseAdapter getMenuHoverListener() {
        if (this.menuHandler == null) {
            return new MouseAdapter(this){};
        }
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Component component = e.getComponent();
                if (!component.isEnabled()) {
                    MenuItemManager.this.menuHandler.menuItemEntered(MenuItemManager.this.action);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Component component = e.getComponent();
                if (!component.isEnabled()) {
                    MenuItemManager.this.menuHandler.menuItemExited(MenuItemManager.this.action);
                }
            }
        };
    }

    private ChangeListener getButtonModelChangeListener() {
        if (this.menuHandler == null) {
            return e -> {};
        }
        return e -> {
            if (!this.menuItem.isShowing()) {
                return;
            }
            boolean isArmed = this.menuItem.isArmed();
            if (isArmed) {
                this.menuHandler.menuItemEntered(this.action);
            } else {
                this.menuHandler.menuItemExited(this.action);
            }
        };
    }

    @Override
    public String getGroup() {
        MenuData menuData = this.isPopup ? this.action.getPopupMenuData() : this.action.getMenuBarData();
        return menuData == null ? null : menuData.getMenuGroup();
    }

    @Override
    public String getSubGroup() {
        MenuData menuData = this.isPopup ? this.action.getPopupMenuData() : this.action.getMenuBarData();
        return menuData == null ? null : menuData.getMenuSubGroup();
    }

    @Override
    public void dispose() {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this);
        }
        if (this.menuItem != null) {
            ButtonModel buttonModel = this.menuItem.getModel();
            buttonModel.removeChangeListener(this.buttonModelChangeListener);
            this.menuItem = null;
        }
        this.action = null;
    }

    @Override
    public JMenuItem getMenuItem() {
        if (this.menuItem != null) {
            return this.menuItem;
        }
        this.menuItem = this.action.createMenuItem(this.isPopup);
        this.menuItem.setEnabled(this.action.isEnabled());
        this.menuItem.addActionListener(this);
        ButtonModel buttonModel = this.menuItem.getModel();
        buttonModel.addChangeListener(this.buttonModelChangeListener);
        this.menuItem.addMouseListener(this.menuHoverListener);
        return this.menuItem;
    }

    public String getOwner() {
        return this.action.getOwner();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.menuItem == null) {
            return;
        }
        String name = e.getPropertyName();
        if (this.isPopup && name.equals("PopupMenu")) {
            this.updateMenuItem();
        } else if (!this.isPopup && name.equals("MenuBar")) {
            this.updateMenuItem();
        } else if (name.equals("enabled")) {
            this.menuItem.setEnabled((Boolean)e.getNewValue());
            this.menuItem.repaint();
        } else if (name.equals("KeyBindings")) {
            KeyBindingData newData = (KeyBindingData)e.getNewValue();
            this.menuItem.setAccelerator(newData == null ? null : newData.getKeyBinding());
            this.menuItem.revalidate();
        } else if (name.equals("selectState")) {
            this.menuItem.setSelected((Boolean)e.getNewValue());
            this.menuItem.revalidate();
        }
    }

    private void updateMenuItem() {
        MenuData menuData;
        MenuData menuData2 = menuData = this.isPopup ? this.action.getPopupMenuData() : this.action.getMenuBarData();
        if (menuData != null) {
            String text = menuData.getMenuItemName();
            String trimmed = StringUtilities.trimMiddle((String)text, (int)50);
            this.menuItem.setText(trimmed);
            Icon menuIcon = menuData.getMenuIcon();
            this.menuItem.setIcon(menuIcon);
            if (menuIcon != null) {
                this.menuItem.setDisabledIcon(ResourceManager.getDisabledIcon((Icon)menuIcon));
            }
            this.menuItem.setMnemonic(menuData.getMnemonic());
            this.menuItem.revalidate();
        }
    }

    public DockingActionIf getAction() {
        return this.action;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.menuHandler != null) {
            this.menuHandler.processMenuAction(this.action, e);
            return;
        }
        try {
            DefaultActionContext context = new DefaultActionContext();
            context.setSourceObject(e.getSource());
            if (this.action.isEnabledForContext(context)) {
                if (this.action instanceof ToggleDockingActionIf) {
                    ToggleDockingActionIf toggleAction;
                    toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)this.action).isSelected());
                }
                this.action.actionPerformed(context);
            }
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + t.getMessage()), (Throwable)t);
        }
    }

    public String toString() {
        return this.action.getName();
    }

    @Override
    public String getMenuItemText() {
        MenuData menuData = this.isPopup ? this.action.getPopupMenuData() : this.action.getMenuBarData();
        return menuData.getMenuItemName();
    }

    @Override
    public boolean isEmpty() {
        return this.action == null;
    }

    @Override
    public boolean removeAction(DockingActionIf actionToRemove) {
        if (actionToRemove == this.action) {
            this.dispose();
            return true;
        }
        return false;
    }
}

