/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.actions.ConvertConstantAction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.HelpLocation;

public class ConvertHexAction
extends ConvertConstantAction {
    public ConvertHexAction(DecompilePlugin plugin) {
        super(plugin, "Convert To Hexadecimal", 1);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionConvert"));
        this.setPopupMenuData(new MenuData(new String[]{"Hexadecimal"}, "Decompile"));
    }

    @Override
    public String getMenuPrefix() {
        return "Hexadecimal: ";
    }

    @Override
    public String getMenuDisplay(long value, int size, boolean isSigned, Program program) {
        Scalar scalar = new Scalar(size * 8, value);
        if (isSigned) {
            long v = scalar.getSignedValue();
            String valueStr = Long.toString(v, 16);
            if (v < 0L) {
                return "-0x" + valueStr.substring(1);
            }
            return "0x" + valueStr;
        }
        String valueStr = Long.toHexString(scalar.getUnsignedValue());
        return "0x" + valueStr;
    }

    @Override
    public String getEquateName(long value, int size, boolean isSigned, Program program) {
        Scalar scalar = new Scalar(size * 8, value);
        if (isSigned) {
            long v = scalar.getSignedValue();
            String valueStr = Long.toString(v, 16).toUpperCase();
            if (v < 0L) {
                return "-0x" + valueStr.substring(1);
            }
            return "0x" + valueStr;
        }
        String valueStr = Long.toHexString(scalar.getUnsignedValue()).toUpperCase();
        return "0x" + valueStr;
    }
}

