/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.util;

import com.google.common.base.Preconditions;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.EdgeIndexFunction;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DefaultParallelEdgeIndexFunction<V, E>
implements EdgeIndexFunction<V, E> {
    protected Map<Context<Graph<V, E>, E>, Integer> edge_index = new HashMap<Context<Graph<V, E>, E>, Integer>();

    private DefaultParallelEdgeIndexFunction() {
    }

    public static <V, E> DefaultParallelEdgeIndexFunction<V, E> getInstance() {
        return new DefaultParallelEdgeIndexFunction<V, E>();
    }

    @Override
    public int getIndex(Graph<V, E> graph, E e) {
        Preconditions.checkNotNull(graph, (Object)"graph must not be null");
        Preconditions.checkNotNull(e, (Object)"'e' must not be null");
        Integer index = this.edge_index.get(Context.getInstance(graph, e));
        if (index == null) {
            V v;
            Pair<V> endpoints = graph.getEndpoints(e);
            V u = endpoints.getFirst();
            index = u.equals(v = endpoints.getSecond()) ? Integer.valueOf(this.getIndex(graph, e, v)) : Integer.valueOf(this.getIndex(graph, e, u, v));
        }
        return index;
    }

    protected int getIndex(Graph<V, E> graph, E e, V v, V u) {
        HashSet commonEdgeSet = new HashSet(graph.getIncidentEdges(u));
        commonEdgeSet.retainAll(graph.getIncidentEdges(v));
        Iterator iterator = commonEdgeSet.iterator();
        while (iterator.hasNext()) {
            V second;
            Object edge = iterator.next();
            Pair<V> ep = graph.getEndpoints(edge);
            V first = ep.getFirst();
            if (first.equals(second = ep.getSecond())) {
                iterator.remove();
            }
            if (first.equals(v)) continue;
            iterator.remove();
        }
        int count = 0;
        for (Object other : commonEdgeSet) {
            if (e.equals(other)) continue;
            this.edge_index.put(Context.getInstance(graph, other), count);
            ++count;
        }
        this.edge_index.put(Context.getInstance(graph, e), count);
        return count;
    }

    protected int getIndex(Graph<V, E> graph, E e, V v) {
        HashSet commonEdgeSet = new HashSet();
        for (Object another : graph.getIncidentEdges(v)) {
            V u = graph.getOpposite(v, another);
            if (!u.equals(v)) continue;
            commonEdgeSet.add(another);
        }
        int count = 0;
        for (Object other : commonEdgeSet) {
            if (e.equals(other)) continue;
            this.edge_index.put(Context.getInstance(graph, other), count);
            ++count;
        }
        this.edge_index.put(Context.getInstance(graph, e), count);
        return count;
    }

    @Override
    public void reset(Graph<V, E> graph, E e) {
        Pair<V> endpoints = graph.getEndpoints(e);
        this.getIndex(graph, e, endpoints.getFirst());
        this.getIndex(graph, e, endpoints.getFirst(), endpoints.getSecond());
    }

    @Override
    public void reset() {
        this.edge_index.clear();
    }
}

