/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.repulsion;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jungrapht.visualization.layout.algorithms.SpringLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.repulsion.StandardRepulsion;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;

public class StandardSpringRepulsion<V, R extends StandardSpringRepulsion<V, R, B>, B extends Builder<V, R, B>>
implements StandardRepulsion<V, R, B> {
    protected Map<V, SpringLayoutAlgorithm.SpringVertexData> springVertexData;
    protected int repulsionRangeSquared;
    protected Random random;
    protected LayoutModel<V> layoutModel;
    protected Set<V> vertexSet;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder standardBuilder() {
        return StandardSpringRepulsion.builder();
    }

    protected StandardSpringRepulsion(Builder<V, R, B> builder) {
        this.layoutModel = builder.layoutModel;
        this.vertexSet = this.layoutModel.getGraph().vertexSet();
        this.random = builder.random;
        this.springVertexData = builder.springVertexData;
        this.repulsionRangeSquared = builder.repulsionRangeSquared;
    }

    @Override
    public void step() {
    }

    @Override
    public void calculateRepulsion() {
        try {
            for (V vertex : this.vertexSet) {
                if (this.layoutModel.isLocked(vertex)) continue;
                SpringLayoutAlgorithm.SpringVertexData svd = this.springVertexData.getOrDefault(vertex, new SpringLayoutAlgorithm.SpringVertexData());
                double dx = 0.0;
                double dy = 0.0;
                for (V vertex2 : this.vertexSet) {
                    if (vertex == vertex2) continue;
                    Point p = (Point)this.layoutModel.apply(vertex);
                    Point p2 = (Point)this.layoutModel.apply(vertex2);
                    if (p == null || p2 == null) continue;
                    double vx = p.x - p2.x;
                    double vy = p.y - p2.y;
                    double distanceSq = p.distanceSquared(p2);
                    if (distanceSq == 0.0) {
                        dx += this.random.nextDouble();
                        dy += this.random.nextDouble();
                        continue;
                    }
                    if (!(distanceSq < (double)this.repulsionRangeSquared)) continue;
                    double factor = 1.0;
                    dx += factor * vx / distanceSq;
                    dy += factor * vy / distanceSq;
                }
                double dlen = dx * dx + dy * dy;
                if (!(dlen > 0.0)) continue;
                dlen = Math.sqrt(dlen) / 2.0;
                svd.repulsiondx += dx / dlen;
                svd.repulsiondy += dy / dlen;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calculateRepulsion();
        }
    }

    public static class Builder<V, R extends StandardSpringRepulsion<V, R, B>, B extends Builder<V, R, B>>
    implements StandardRepulsion.Builder<V, R, B> {
        protected Map<V, SpringLayoutAlgorithm.SpringVertexData> springVertexData;
        protected int repulsionRangeSquared = 10000;
        protected Random random = new Random();
        protected LayoutModel<V> layoutModel;

        public B nodeData(Map<V, SpringLayoutAlgorithm.SpringVertexData> springVertexData) {
            this.springVertexData = springVertexData;
            return (B)this;
        }

        public B repulsionRangeSquared(int repulsionRangeSquared) {
            this.repulsionRangeSquared = repulsionRangeSquared;
            return (B)this;
        }

        @Override
        public B layoutModel(LayoutModel<V> layoutModel) {
            this.layoutModel = layoutModel;
            return (B)this;
        }

        @Override
        public B random(Random random) {
            this.random = random;
            return (B)this;
        }

        @Override
        public R build() {
            return (R)new StandardSpringRepulsion(this);
        }
    }
}

