/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigInteger;

public class DecodeBitMasks {
    long tmask;
    long wmask;
    long immN;
    long immr;
    long imms;
    int M;

    int HighestSetBit(long x, int bitSize) {
        long mask = 1 << bitSize - 1;
        for (int i = bitSize - 1; i >= 0; --i) {
            if ((mask & x) == mask) {
                return i;
            }
            mask >>= 1;
        }
        return -1;
    }

    long ZeroExtend(long x, int bitSize, int extSize) {
        long mask = this.Ones(bitSize);
        return x &= mask;
    }

    private long Ones(int bitSize) {
        long mask = 0L;
        for (int i = 0; i < bitSize; ++i) {
            mask = mask << 1 | 1L;
        }
        return mask;
    }

    long Replicate(long x, int bitSize, int startBit, int repSize, int extSize) {
        long repval = x >> startBit & this.Ones(repSize);
        int times = extSize / repSize;
        long val = 0L;
        for (int i = 0; i < times; ++i) {
            val = val << repSize | repval;
        }
        repval = val << startBit;
        return x |= repval;
    }

    long ROR(long x, int esize, long rotate) {
        long a = x << (int)((long)esize - rotate) & this.Ones(esize);
        long r = x >> (int)rotate & this.Ones(esize);
        return (a | r) & this.Ones(esize);
    }

    boolean decode(long iN, long is, long ir, boolean immediate, int Msize) {
        this.immN = iN;
        this.imms = is;
        this.immr = ir;
        this.M = Msize;
        this.wmask = 0L;
        this.tmask = 0L;
        int len = this.HighestSetBit(this.immN << 6 | (this.imms ^ 0xFFFFFFFFFFFFFFFFL) & this.Ones(6), 7);
        if (len < 1) {
            System.out.println("bad value " + this.immN + ":" + this.immr + ":" + this.imms);
            return false;
        }
        assert (this.M >= 1 << len);
        long levels = this.ZeroExtend(this.Ones(len), 6, 6);
        if (immediate && (this.imms & levels) == levels) {
            System.out.println("All-Ones " + this.immN + ":" + this.immr + ":" + this.imms);
            return false;
        }
        long S = this.imms & levels;
        long R = this.immr & levels;
        long diff = S - R;
        int esize = 1 << len;
        long d = diff & this.Ones(len - 1);
        long welem = this.ZeroExtend(this.Ones((int)(S + 1L)), esize, esize);
        long telem = this.ZeroExtend(this.Ones((int)(d + 1L)), esize, esize);
        this.wmask = this.Replicate(this.ROR(welem, esize, R), esize, 0, esize, this.M);
        this.tmask = this.Replicate(telem, esize, 0, esize, this.M);
        return true;
    }

    static String bitStr(long value, int bitSize) {
        BigInteger val = BigInteger.valueOf(value);
        val = val.and(new BigInteger("FFFFFFFFFFFFFFFF", 16));
        Object str = val.toString(2);
        for (int len = ((String)str).length(); len < bitSize; ++len) {
            str = "0" + (String)str;
        }
        return str;
    }

    void printit() {
        System.out.println(DecodeBitMasks.bitStr(this.immN, 1) + ":" + DecodeBitMasks.bitStr(this.immr, 6) + ":" + DecodeBitMasks.bitStr(this.imms, 6) + " = " + DecodeBitMasks.bitStr(this.wmask, this.M) + "   " + DecodeBitMasks.bitStr(this.tmask, this.M));
    }

    public static void main(String[] args) {
        int imms;
        int imms2;
        int immr;
        DecodeBitMasks bm = new DecodeBitMasks();
        boolean valid = bm.decode(0L, 0L, 0L, true, 64);
        if (valid) {
            bm.printit();
        }
        int immN = 0;
        for (immr = 0; immr <= 63; ++immr) {
            for (imms2 = 0; imms2 <= 63; ++imms2) {
                valid = bm.decode(immN, imms2, immr, true, 32);
                if (!valid) continue;
                bm.printit();
            }
        }
        for (imms = 0; imms <= 63; ++imms) {
            valid = bm.decode(immN, imms, 0L, true, 32);
            if (!valid) continue;
            bm.printit();
        }
        if (bm.decode(0L, 30L, 31L, true, 32)) {
            bm.printit();
        }
        if (bm.decode(0L, 29L, 30L, true, 32)) {
            bm.printit();
        }
        immN = 0;
        for (immr = 0; immr <= 63; ++immr) {
            for (imms2 = 0; imms2 <= 63; ++imms2) {
                valid = bm.decode(immN, imms2, immr, true, 64);
                if (!valid) continue;
                bm.printit();
            }
        }
        immN = 1;
        for (immr = 0; immr <= 63; ++immr) {
            for (imms2 = 0; imms2 <= 63; ++imms2) {
                valid = bm.decode(immN, imms2, immr, true, 64);
                if (!valid) continue;
                bm.printit();
            }
        }
        immN = 0;
        for (imms = 0; imms <= 63; ++imms) {
            valid = bm.decode(immN, imms, 0L, true, 64);
            if (!valid) continue;
            bm.printit();
        }
        immN = 1;
        for (imms = 0; imms <= 63; ++imms) {
            valid = bm.decode(immN, imms, 0L, true, 64);
            if (!valid) continue;
            bm.printit();
        }
    }
}

