/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.MIPS_ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.MIPS_ElfRelocationType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.AssertException;
import java.util.Iterator;
import java.util.Map;

public class MIPS_ElfRelocationHandler
extends AbstractElfRelocationHandler<MIPS_ElfRelocationType, MIPS_ElfRelocationContext> {
    private static final int MIPS_LOW26 = 0x3FFFFFF;
    private static final int MIPS_LOW21 = 0x1FFFFF;

    public MIPS_ElfRelocationHandler() {
        super(MIPS_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 8;
    }

    public MIPS_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return new MIPS_ElfRelocationContext(this, loadHelper, symbolMap);
    }

    protected RelocationResult relocate(MIPS_ElfRelocationContext elfRelocationContext, ElfRelocation relocation, MIPS_ElfRelocationType type, Address relocationAddress, ElfSymbol elfSymbol, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        int symbolIndex;
        boolean saveValue = elfRelocationContext.saveValueForNextReloc;
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        MessageLog log = elfRelocationContext.getLog();
        ElfHeader elf = elfRelocationContext.getElfHeader();
        long offset = (int)relocationAddress.getOffset();
        int n = symbolIndex = elfSymbol != null ? elfSymbol.getSymbolTableIndex() : 0;
        if (symbolIndex != 0) {
            elfRelocationContext.lastSymbolAddr = symbolAddr;
            elfRelocationContext.lastElfSymbol = elfSymbol;
        }
        long addend = 0L;
        if (elfRelocationContext.useSavedAddend) {
            if (elfRelocationContext.savedAddendHasError) {
                this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Stacked relocation failure", log);
                elfRelocationContext.useSavedAddend = saveValue;
                elfRelocationContext.savedAddend = 0L;
                return RelocationResult.FAILURE;
            }
            addend = elfRelocationContext.savedAddend;
        } else if (relocation.hasAddend()) {
            addend = relocation.getAddend();
        }
        if (!elfSymbol.isLocal()) {
            if (type == MIPS_ElfRelocationType.R_MIPS_GOT_PAGE) {
                type = MIPS_ElfRelocationType.R_MIPS_GOT_DISP;
                addend = 0L;
            } else if (type == MIPS_ElfRelocationType.R_MICROMIPS_GOT_PAGE) {
                type = MIPS_ElfRelocationType.R_MICROMIPS_GOT_DISP;
                addend = 0L;
            }
        }
        elfRelocationContext.savedAddendHasError = false;
        elfRelocationContext.savedAddend = 0L;
        boolean isGpDisp = false;
        if ("_gp_disp".equals(symbolName)) {
            isGpDisp = true;
        } else if ("__gnu_local_gp".equals(symbolName)) {
            this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "__gnu_local_gp relocation not yet supported", log);
            if (saveValue) {
                elfRelocationContext.savedAddendHasError = true;
            }
            return RelocationResult.FAILURE;
        }
        long oldValue = Integer.toUnsignedLong(this.unshuffle(memory.getInt(relocationAddress), type, elfRelocationContext));
        long value = 0L;
        long newValue = 0L;
        boolean writeNewValue = false;
        Relocation.Status status = Relocation.Status.PARTIAL;
        int byteLength = 4;
        switch (type) {
            case R_MIPS_GOT_OFST: 
            case R_MICROMIPS_GOT_OFST: {
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue & 0xFFFFL;
                }
                long pageOffset = symbolValue + addend + 32768L & 0xFFFFFFFFFFFF0000L;
                value = symbolValue + addend - pageOffset;
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case R_MIPS_GOT_PAGE: 
            case R_MICROMIPS_GOT_PAGE: {
                long pageOffset;
                Address gotAddr;
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue & 0xFFFFL;
                }
                if ((gotAddr = elfRelocationContext.getSectionGotAddress(pageOffset = symbolValue + addend + 32768L & 0xFFFFFFFFFFFF0000L)) == null) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Unable to allocate GOT entry", log);
                    return RelocationResult.FAILURE;
                }
                value = this.getGpOffset(elfRelocationContext, gotAddr.getOffset());
                if (value == -1L) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to perform GP-based relocation", log);
                    if (saveValue) {
                        elfRelocationContext.savedAddendHasError = true;
                    }
                    return RelocationResult.FAILURE;
                }
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case R_MIPS_GOT_DISP: 
            case R_MICROMIPS_GOT_DISP: 
            case R_MIPS_GOT_HI16: 
            case R_MICROMIPS_GOT_HI16: {
                Address gotAddr = elfRelocationContext.getSectionGotAddress(symbolValue);
                if (gotAddr == null) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Unable to allocate GOT entry", log);
                    return RelocationResult.FAILURE;
                }
                value = this.getGpOffset(elfRelocationContext, gotAddr.getOffset());
                if (value == -1L) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to perform GP-based relocation", log);
                    if (saveValue) {
                        elfRelocationContext.savedAddendHasError = true;
                    }
                    return RelocationResult.FAILURE;
                }
                long appliedValue = type == MIPS_ElfRelocationType.R_MIPS_GOT_DISP ? value & 0xFFFFL : value + 32768L >> 16 & 0xFFFFL;
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | appliedValue;
                writeNewValue = true;
                break;
            }
            case R_MIPS_GOT16: 
            case R_MIPS16_GOT16: 
            case R_MICROMIPS_GOT16: {
                if (elfSymbol.isLocal()) {
                    MIPS_DeferredRelocation got16reloc = new MIPS_DeferredRelocation(type, elfSymbol, relocationAddress, oldValue, addend, isGpDisp);
                    elfRelocationContext.addGOT16Relocation(got16reloc);
                    break;
                }
            }
            case R_MIPS_CALL16: 
            case R_MIPS16_CALL16: 
            case R_MICROMIPS_CALL16: {
                Address gotAddr = elfRelocationContext.getSectionGotAddress(symbolValue + addend);
                if (gotAddr == null) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Unable to allocate GOT entry", log);
                    return RelocationResult.FAILURE;
                }
                value = this.getGpOffset(elfRelocationContext, gotAddr.getOffset());
                if (value == -1L) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to perform GP-based relocation", log);
                    if (saveValue) {
                        elfRelocationContext.savedAddendHasError = true;
                    }
                    return RelocationResult.FAILURE;
                }
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case R_MIPS_CALL_HI16: 
            case R_MICROMIPS_CALL_HI16: {
                Address gotAddr = elfRelocationContext.getSectionGotAddress(symbolValue + addend);
                if (gotAddr == null) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Unable to allocate GOT entry", log);
                    return RelocationResult.FAILURE;
                }
                value = this.getGpOffset(elfRelocationContext, gotAddr.getOffset());
                if (value == -1L) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to perform GP-based relocation", log);
                    if (saveValue) {
                        elfRelocationContext.savedAddendHasError = true;
                    }
                    return RelocationResult.FAILURE;
                }
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value + 32768L >> 16 & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case R_MIPS_HI16: 
            case R_MIPS16_HI16: 
            case R_MICROMIPS_HI16: {
                if (elfRelocationContext.getGPValue() == -1L) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to perform GP-based relocation", log);
                    return RelocationResult.FAILURE;
                }
                MIPS_DeferredRelocation hi16reloc = new MIPS_DeferredRelocation(type, elfSymbol, relocationAddress, oldValue, (int)addend, isGpDisp);
                elfRelocationContext.addHI16Relocation(hi16reloc);
                break;
            }
            case R_MIPS_LO16: 
            case R_MIPS16_LO16: 
            case R_MICROMIPS_LO16: 
            case R_MICROMIPS_HI0_LO16: {
                if (elfRelocationContext.extractAddend()) {
                    addend = (short)(oldValue & 0xFFFFL);
                }
                this.processHI16Relocations(elfRelocationContext, type, elfSymbol, (int)addend);
                this.processGOT16Relocations(elfRelocationContext, type, elfSymbol, (int)addend);
                if (isGpDisp) {
                    value = elfRelocationContext.getGPValue();
                    if (value == -1L) {
                        this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to perform GP-based relocation", log);
                        if (saveValue) {
                            elfRelocationContext.savedAddendHasError = true;
                        }
                        return RelocationResult.FAILURE;
                    }
                    value = type == MIPS_ElfRelocationType.R_MIPS16_LO16 ? (value -= offset & 0xFFFFFFFFFFFFFFFCL) : (value -= offset - 4L);
                } else {
                    value = (int)symbolValue;
                }
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | (value += addend) & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case R_MIPS_REL32: {
                if (symbolIndex == 0) {
                    symbolValue = elfRelocationContext.getImageBaseWordAdjustmentOffset();
                }
                value = symbolValue;
                if (elfRelocationContext.extractAddend()) {
                    addend = saveValue && program.getDefaultPointerSize() == 8 ? memory.getLong(relocationAddress) : (long)memory.getInt(relocationAddress);
                }
                newValue = value + addend;
                if (saveValue) {
                    elfRelocationContext.savedAddend = newValue;
                    break;
                }
                memory.setInt(relocationAddress, (int)newValue);
                status = Relocation.Status.APPLIED;
                if (symbolIndex == 0 || addend == 0L || elfSymbol.isSection()) break;
                MIPS_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)log);
                MIPS_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case R_MIPS_32: {
                value = symbolValue;
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = value + addend;
                if (saveValue) {
                    elfRelocationContext.savedAddend = newValue;
                    break;
                }
                memory.setInt(relocationAddress, (int)newValue);
                status = Relocation.Status.APPLIED;
                break;
            }
            case R_MIPS_26: 
            case R_MIPS16_26: 
            case R_MICROMIPS_26_S1: {
                int shift;
                int n2 = shift = type == MIPS_ElfRelocationType.R_MICROMIPS_26_S1 ? 1 : 2;
                if (elfRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x3FFFFFFL) << shift;
                }
                if (!elfSymbol.isLocal() && !elfSymbol.isSection()) {
                    addend = this.signExtend((int)addend, 26 + shift);
                }
                value = addend + symbolValue >> shift;
                newValue = oldValue & 0xFFFFFFFFFC000000L | value & 0x3FFFFFFL;
                writeNewValue = true;
                break;
            }
            case R_MIPS_PC21_S2: {
                if (elfRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x1FFFFFL) << 2;
                }
                if (!elfSymbol.isLocal() && !elfSymbol.isSection()) {
                    addend = this.signExtend((int)addend, 23);
                }
                value = addend + symbolValue - offset >> 2;
                newValue = oldValue & 0xFFFFFFFFFFE00000L | value & 0x1FFFFFL;
                writeNewValue = true;
                break;
            }
            case R_MIPS_PC26_S2: {
                if (elfRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x3FFFFFFL) << 2;
                }
                if (!elfSymbol.isLocal() && !elfSymbol.isSection()) {
                    addend = this.signExtend((int)addend, 28);
                }
                value = addend + symbolValue - offset >> 2;
                newValue = oldValue & 0xFFFFFFFFFC000000L | value & 0x3FFFFFFL;
                writeNewValue = true;
                break;
            }
            case R_MIPS_PC16: {
                if (elfRelocationContext.extractAddend()) {
                    addend = (oldValue & 0xFFFFL) << 2;
                }
                value = symbolValue - offset + (long)this.signExtend((int)addend, 18);
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value >> 2 & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case R_MIPS_64: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getLong(relocationAddress);
                }
                newValue = symbolValue + addend;
                if (saveValue) {
                    elfRelocationContext.savedAddend = newValue;
                    break;
                }
                memory.setLong(relocationAddress, newValue);
                byteLength = 8;
                status = Relocation.Status.APPLIED;
                boolean isSectionBased = elfSymbol.isSection();
                Address addr = symbolAddr;
                if (symbolIndex == 0 && elfRelocationContext.lastSymbolAddr != null) {
                    addr = elfRelocationContext.lastSymbolAddr;
                    symbolName = elfRelocationContext.lastElfSymbol.getNameAsString();
                    isSectionBased = elfRelocationContext.lastElfSymbol.isSection();
                }
                if (addr == null || isSectionBased) break;
                if (symbolIndex == 0) {
                    addend -= addr.getOffset();
                }
                if (addend == 0L) break;
                MIPS_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)addr, (String)symbolName, (long)addend, (MessageLog)log);
                if (!elf.is64Bit()) break;
                MIPS_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case R_MIPS_HIGHER: 
            case R_MICROMIPS_HIGHER: {
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue;
                }
                value = symbolValue + 0x80008000L + (addend &= 0xFFFFL);
                value = value >> 32 & 0xFFFFL;
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value;
                writeNewValue = true;
                break;
            }
            case R_MIPS_HIGHEST: 
            case R_MICROMIPS_HIGHEST: {
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue;
                }
                value = symbolValue + 0x80008000L + (addend &= 0xFFFFL);
                value = value >> 48 & 0xFFFFL;
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value;
                writeNewValue = true;
                break;
            }
            case R_MICROMIPS_PC7_S1: {
                if (elfRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x7F0000L) >> 15;
                }
                value = symbolValue + addend - offset >> 1 & 0x7FL;
                newValue = oldValue & 0xFFFFFFFFFF80FFFFL | value << 16;
                writeNewValue = true;
                break;
            }
            case R_MICROMIPS_PC10_S1: {
                if (elfRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x3FF0000L) >> 15;
                }
                value = symbolValue + addend - offset >> 1 & 0x3FFL;
                newValue = oldValue & 0xFFFFFFFFFC00FFFFL | value << 16;
                writeNewValue = true;
                break;
            }
            case R_MICROMIPS_PC16_S1: {
                if (elfRelocationContext.extractAddend()) {
                    addend = (oldValue & 0xFFFFL) << 1;
                }
                value = symbolValue + addend - offset >> 1 & 0xFFFFL;
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value;
                writeNewValue = true;
                break;
            }
            case R_MIPS_GPREL16: 
            case R_MIPS_GPREL32: 
            case R_MIPS16_GPREL: 
            case R_MICROMIPS_GPREL16: 
            case R_MICROMIPS_GPREL7_S2: 
            case R_MIPS_LITERAL: 
            case R_MICROMIPS_LITERAL: {
                long gp;
                if (elfRelocationContext.extractAddend()) {
                    if (type == MIPS_ElfRelocationType.R_MIPS_GPREL32) {
                        addend = oldValue;
                    } else {
                        addend = oldValue & 0xFFFFL;
                        if (type == MIPS_ElfRelocationType.R_MICROMIPS_GPREL7_S2) {
                            addend <<= 2;
                        }
                        addend = this.signExtend((int)addend, 16);
                    }
                }
                long gp0 = 0L;
                if (elfSymbol.isLocal() && (type == MIPS_ElfRelocationType.R_MIPS_GPREL16 || type == MIPS_ElfRelocationType.R_MIPS_GPREL32)) {
                    gp0 = elfRelocationContext.getGP0Value();
                    if (gp0 == -1L) {
                        this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to perform GP0-based relocation (requires .reginfo data)", log);
                        if (saveValue) {
                            elfRelocationContext.savedAddendHasError = true;
                        }
                        return RelocationResult.FAILURE;
                    }
                    if (gp0 == 0L) {
                        gp0 = elfRelocationContext.getImageBaseWordAdjustmentOffset();
                    }
                }
                if ((gp = elfRelocationContext.getGPValue()) == -1L) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to perform GP-based relocation", log);
                    if (saveValue) {
                        elfRelocationContext.savedAddendHasError = true;
                    }
                    return RelocationResult.FAILURE;
                }
                value = symbolValue + addend - gp + gp0;
                long mask = type == MIPS_ElfRelocationType.R_MIPS_GPREL32 ? 0xFFFFFFFFL : 65535L;
                newValue = oldValue & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value & mask;
                writeNewValue = true;
                break;
            }
            case R_MIPS_SUB: 
            case R_MICROMIPS_SUB: {
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue;
                }
                newValue = symbolValue - addend;
                if (saveValue) {
                    elfRelocationContext.savedAddend = newValue;
                    break;
                }
                memory.setLong(relocationAddress, newValue);
                byteLength = 8;
                status = Relocation.Status.APPLIED;
                break;
            }
            case R_MIPS_COPY: {
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, elfSymbol.getSize(), elfRelocationContext.getLog());
                if (saveValue) {
                    elfRelocationContext.savedAddendHasError = true;
                }
                return RelocationResult.UNSUPPORTED;
            }
            case R_MIPS_JUMP_SLOT: {
                if (saveValue) {
                    elfRelocationContext.savedAddend = symbolValue;
                } else if (elfRelocationContext.getElfHeader().is64Bit()) {
                    memory.setLong(relocationAddress, symbolValue);
                    byteLength = 8;
                } else {
                    memory.setInt(relocationAddress, (int)symbolValue);
                }
                status = Relocation.Status.APPLIED;
                break;
            }
            case R_MIPS_JALR: 
            case R_MICROMIPS_JALR: {
                MemoryBlock block;
                boolean success = false;
                if (symbolAddr != null && (block = memory.getBlock(symbolAddr)) != null) {
                    if ("EXTERNAL".equals(block.getName())) {
                        boolean bl = success = elfRelocationContext.getLoadHelper().createExternalFunctionLinkage(symbolName, symbolAddr, null) != null;
                        if (success) {
                            if (type == MIPS_ElfRelocationType.R_MICROMIPS_JALR) {
                                int offsetBits = (int)(symbolValue >> 1) & 0x3FFFFFF;
                                int microJalrBits = 0xF4000000 | offsetBits;
                                memory.setShort(relocationAddress, (short)(microJalrBits >>> 16));
                                memory.setShort(relocationAddress.add(2L), (short)microJalrBits);
                            } else {
                                int offsetBits = (int)(symbolValue >> 2) & 0x3FFFFFF;
                                int jalrBits = 0xC000000 | offsetBits;
                                memory.setInt(relocationAddress, jalrBits);
                            }
                            status = Relocation.Status.APPLIED;
                        }
                    } else {
                        return RelocationResult.SKIPPED;
                    }
                }
                if (success) break;
                this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to establish external linkage", log);
                return RelocationResult.FAILURE;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, log);
                if (saveValue) {
                    elfRelocationContext.savedAddendHasError = true;
                }
                return RelocationResult.UNSUPPORTED;
            }
        }
        if (writeNewValue) {
            if (saveValue) {
                elfRelocationContext.savedAddend = value;
            } else {
                memory.setInt(relocationAddress, this.shuffle((int)newValue, type, elfRelocationContext));
                status = Relocation.Status.APPLIED;
            }
        }
        elfRelocationContext.useSavedAddend = saveValue;
        return new RelocationResult(status, byteLength);
    }

    private boolean isMIPS16Reloc(MIPS_ElfRelocationType type) {
        int typeId = type.typeId;
        return typeId >= MIPS_ElfRelocationType.R_MIPS16_LO.typeId && typeId <= MIPS_ElfRelocationType.R_MIPS16_HI.typeId;
    }

    private boolean isMicroMIPSReloc(MIPS_ElfRelocationType type) {
        int typeId = type.typeId;
        return typeId >= MIPS_ElfRelocationType.R_MICROMIPS_LO.typeId && typeId <= MIPS_ElfRelocationType.R_MICROMIPS_HI.typeId;
    }

    private boolean shuffleRequired(MIPS_ElfRelocationType type) {
        return this.isMIPS16Reloc(type) || this.isMicroMIPSReloc(type) && type != MIPS_ElfRelocationType.R_MICROMIPS_PC7_S1 && type != MIPS_ElfRelocationType.R_MICROMIPS_PC10_S1;
    }

    private boolean isMIPS16_26_JAL_Reloc(MIPS_ElfRelocationType type, MIPS_ElfRelocationContext elfRelocationContext) {
        return type == MIPS_ElfRelocationType.R_MIPS16_26 && elfRelocationContext.getElfHeader().isRelocatable();
    }

    private int unshuffle(int value, MIPS_ElfRelocationType type, MIPS_ElfRelocationContext elfRelocationContext) {
        int second;
        int first;
        if (!this.shuffleRequired(type)) {
            return value;
        }
        if (elfRelocationContext.isBigEndian()) {
            first = value >>> 16;
            second = value & 0xFFFF;
        } else {
            first = value & 0xFFFF;
            second = value >>> 16;
        }
        value = this.isMIPS16_26_JAL_Reloc(type, elfRelocationContext) ? (first & 0xF800) << 16 | (second & 0xFFE0) << 11 | (first & 0x1F) << 11 | first & 0x7E0 | second & 0x1F : (this.isMicroMIPSReloc(type) || type == MIPS_ElfRelocationType.R_MIPS16_26 ? first << 16 | second : (first & 0xFC00) << 16 | (first & 0x3E0) << 11 | (first & 0x1F) << 21 | second);
        return value;
    }

    private int shuffle(int value, MIPS_ElfRelocationType type, MIPS_ElfRelocationContext elfRelocationContext) {
        short second;
        short first;
        if (!this.shuffleRequired(type)) {
            return value;
        }
        if (this.isMIPS16_26_JAL_Reloc(type, elfRelocationContext)) {
            first = (short)(value >> 16 & 0xF800 | value >> 11 & 0x1F | value & 0x7E0);
            second = (short)(value >> 11 & 0xFFE0 | value & 0x1F);
        } else if (this.isMicroMIPSReloc(type) || type == MIPS_ElfRelocationType.R_MIPS16_26) {
            first = (short)(value >> 16);
            second = (short)value;
        } else {
            first = (short)(value >> 16 & 0xFC00 | value >> 11 & 0x3E0 | value >> 21 & 0x1F);
            second = (short)value;
        }
        value = elfRelocationContext.isBigEndian() ? first << 16 | second & 0xFFFF : second << 16 | first & 0xFFFF;
        return value;
    }

    private boolean matchingHiLo16Types(MIPS_ElfRelocationType hi16Type, MIPS_ElfRelocationType lo16Type) {
        switch (hi16Type) {
            case R_MIPS_GOT16: 
            case R_MIPS_HI16: {
                return lo16Type == MIPS_ElfRelocationType.R_MIPS_LO16;
            }
            case R_MIPS16_GOT16: 
            case R_MIPS16_HI16: {
                return lo16Type == MIPS_ElfRelocationType.R_MIPS16_LO16;
            }
            case R_MICROMIPS_GOT16: 
            case R_MICROMIPS_HI16: {
                return lo16Type == MIPS_ElfRelocationType.R_MICROMIPS_LO16;
            }
        }
        return false;
    }

    private int signExtend(int val, int bits) {
        int shift = 32 - bits;
        return val << shift >> shift;
    }

    private void processHI16Relocations(MIPS_ElfRelocationContext elfRelocationContext, MIPS_ElfRelocationType lo16RelocType, ElfSymbol lo16ElfSymbol, int lo16Addend) {
        Iterator<MIPS_DeferredRelocation> iterateHi16 = elfRelocationContext.iterateHi16();
        while (iterateHi16.hasNext()) {
            MIPS_DeferredRelocation hi16reloc = iterateHi16.next();
            if (!this.matchingHiLo16Types(hi16reloc.relocType, lo16RelocType) || hi16reloc.elfSymbol != lo16ElfSymbol) continue;
            this.processHI16Relocation(elfRelocationContext, hi16reloc, lo16Addend);
            iterateHi16.remove();
        }
    }

    private void processHI16Relocation(MIPS_ElfRelocationContext elfRelocationContext, MIPS_DeferredRelocation hi16reloc, long lo16Addend) {
        long newValue;
        if (hi16reloc.isGpDisp) {
            newValue = (int)elfRelocationContext.getGPValue();
            if (newValue == -1L) {
                this.markAsError(elfRelocationContext.getProgram(), hi16reloc.relocAddr, hi16reloc.relocType, hi16reloc.elfSymbol.getNameAsString(), hi16reloc.elfSymbol.getSymbolTableIndex(), "Failed to perform GP-based relocation", elfRelocationContext.getLog());
                return;
            }
            newValue = hi16reloc.relocType == MIPS_ElfRelocationType.R_MIPS16_HI16 ? (newValue -= hi16reloc.relocAddr.getOffset() + 4L & 0xFFFFFFFFFFFFFFFCL) : (newValue -= hi16reloc.relocAddr.getOffset());
        } else {
            newValue = (int)elfRelocationContext.getSymbolValue(hi16reloc.elfSymbol);
        }
        long addend = elfRelocationContext.extractAddend() ? ((hi16reloc.oldValueL & 0xFFFFL) << 16) + lo16Addend : hi16reloc.addendL;
        newValue = newValue + addend + 32768L >> 16;
        newValue = hi16reloc.oldValueL & 0xFFFFFFFFFFFF0000L | newValue & 0xFFFFL;
        Memory memory = elfRelocationContext.getProgram().getMemory();
        try {
            memory.setInt(hi16reloc.relocAddr, this.shuffle((int)newValue, hi16reloc.relocType, elfRelocationContext));
        }
        catch (MemoryAccessException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private void processGOT16Relocations(MIPS_ElfRelocationContext elfRelocationContext, MIPS_ElfRelocationType lo16RelocType, ElfSymbol lo16ElfSymbol, int lo16Addend) {
        Iterator<MIPS_DeferredRelocation> iterateGot16 = elfRelocationContext.iterateGot16();
        while (iterateGot16.hasNext()) {
            MIPS_DeferredRelocation hi16reloc = iterateGot16.next();
            if (!this.matchingHiLo16Types(hi16reloc.relocType, lo16RelocType) || hi16reloc.elfSymbol != lo16ElfSymbol) continue;
            this.processGOT16Relocation(elfRelocationContext, hi16reloc, lo16Addend);
            iterateGot16.remove();
        }
    }

    private void processGOT16Relocation(MIPS_ElfRelocationContext elfRelocationContext, MIPS_DeferredRelocation got16reloc, long lo16Addend) {
        long addend = elfRelocationContext.extractAddend() ? ((got16reloc.oldValueL & 0xFFFFL) << 16) + lo16Addend : got16reloc.addendL;
        long symbolValue = (int)elfRelocationContext.getSymbolValue(got16reloc.elfSymbol);
        String symbolName = got16reloc.elfSymbol.getNameAsString();
        long value = symbolValue + addend + 32768L & 0xFFFFFFFFFFFF0000L;
        Address gotAddr = elfRelocationContext.getSectionGotAddress(value);
        if (gotAddr == null) {
            this.markAsError(elfRelocationContext.getProgram(), got16reloc.relocAddr, got16reloc.relocType, symbolName, got16reloc.elfSymbol.getSymbolTableIndex(), "Unable to allocate GOT entry", elfRelocationContext.getLog());
            return;
        }
        value = this.getGpOffset(elfRelocationContext, gotAddr.getOffset());
        if (value == -1L) {
            this.markAsError(elfRelocationContext.getProgram(), got16reloc.relocAddr, got16reloc.relocType, symbolName, got16reloc.elfSymbol.getSymbolTableIndex(), "Failed to perform GP-based relocation", elfRelocationContext.getLog());
            return;
        }
        long newValue = got16reloc.oldValueL & 0xFFFFFFFFFFFF0000L | (long)((int)value & 0xFFFF);
        Memory memory = elfRelocationContext.getProgram().getMemory();
        try {
            memory.setInt(got16reloc.relocAddr, this.shuffle((int)newValue, got16reloc.relocType, elfRelocationContext));
        }
        catch (MemoryAccessException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private long getGpOffset(MIPS_ElfRelocationContext elfRelocationContext, long value) {
        long gp = elfRelocationContext.getGPValue();
        if (gp == -1L) {
            return -1L;
        }
        return value - gp;
    }

    class MIPS_DeferredRelocation {
        final MIPS_ElfRelocationType relocType;
        final ElfSymbol elfSymbol;
        final Address relocAddr;
        final long oldValueL;
        final long addendL;
        final boolean isGpDisp;

        MIPS_DeferredRelocation(MIPS_ElfRelocationType relocType, ElfSymbol elfSymbol, Address relocAddr, long oldValue, long addend, boolean isGpDisp) {
            this.relocType = relocType;
            this.elfSymbol = elfSymbol;
            this.relocAddr = relocAddr;
            this.oldValueL = oldValue;
            this.addendL = addend;
            this.isGpDisp = isGpDisp;
        }

        void markUnprocessed(MIPS_ElfRelocationContext elfRelocationContext, String missingDependencyName) {
            MIPS_ElfRelocationHandler.this.markAsError(elfRelocationContext.getProgram(), this.relocAddr, this.relocType, this.elfSymbol.getNameAsString(), this.elfSymbol.getSymbolTableIndex(), "Relocation missing required " + missingDependencyName, elfRelocationContext.getLog());
        }
    }
}

