/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge;

import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.merge.MergeManager;
import ghidra.app.merge.MergeManagerPlugin;
import ghidra.app.merge.MergeManagerProvider;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.services.ProgramManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.net.URL;
import javax.swing.JComponent;

@PluginInfo(status=PluginStatus.HIDDEN, packageName="Ghidra Core", category="Common", shortDescription="Program Merge Manager", description="Manage merge of Programs", servicesProvided={ProgramManager.class}, eventsConsumed={ProgramActivatedPluginEvent.class})
public class ProgramMergeManagerPlugin
extends MergeManagerPlugin
implements ProgramManager {
    public ProgramMergeManagerPlugin(PluginTool tool, ProgramMultiUserMergeManager mergeManager, Program program) {
        super(tool, mergeManager, (DomainObject)program);
    }

    @Override
    public MergeManagerProvider createProvider() {
        return new MergeManagerProvider(this, "Merge Programs for " + this.currentDomainObject.getName());
    }

    @Override
    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            Program activeProgram = ((ProgramActivatedPluginEvent)event).getActiveProgram();
            this.currentDomainObject = activeProgram;
        }
    }

    @Override
    protected void dispose() {
        this.provider.dispose();
    }

    @Override
    MergeManager getMergeManager() {
        return this.mergeManager;
    }

    @Override
    void setMergeComponent(JComponent component, String componentID) {
        this.provider.setMergeComponent(component, componentID);
    }

    @Override
    void updateMergeDescription(String mergeDescription) {
        this.provider.updateMergeDescription(mergeDescription);
    }

    @Override
    void updateProgressDetails(String progressDescription) {
        this.provider.updateProgressDetails(progressDescription);
    }

    @Override
    void setCurrentProgress(int currentPercentProgress) {
        this.provider.setCurrentProgress(currentPercentProgress);
    }

    @Override
    void showDefaultComponent() {
        this.provider.showDefaultComponent();
    }

    @Override
    void setApplyEnabled(boolean state) {
        this.provider.setApplyEnabled(state);
    }

    @Override
    MergeManagerProvider getProvider() {
        return this.provider;
    }

    @Override
    public boolean closeOtherPrograms(boolean ignoreChanges) {
        return false;
    }

    @Override
    public boolean closeAllPrograms(boolean ignoreChanges) {
        return false;
    }

    @Override
    public boolean closeProgram() {
        return false;
    }

    @Override
    public boolean closeProgram(Program program, boolean ignoreChanges) {
        return false;
    }

    @Override
    public Program[] getAllOpenPrograms() {
        ProgramMultiUserMergeManager programMergeManager = (ProgramMultiUserMergeManager)this.mergeManager;
        return new Program[]{programMergeManager.getProgram(0), programMergeManager.getProgram(1), programMergeManager.getProgram(2), programMergeManager.getProgram(3)};
    }

    @Override
    public Program getCurrentProgram() {
        return (Program)this.currentDomainObject;
    }

    @Override
    public Program getProgram(Address addr) {
        return null;
    }

    public int getSearchPriority(Program p) {
        return 0;
    }

    @Override
    public boolean isVisible(Program program) {
        return false;
    }

    @Override
    public Program openProgram(URL ghidraURL, int state) {
        return null;
    }

    @Override
    public Program openCachedProgram(URL ghidraURL, Object consumer) {
        return null;
    }

    @Override
    public Program openProgram(DomainFile domainFile) {
        return null;
    }

    @Override
    public Program openCachedProgram(DomainFile domainFile, Object consumer) {
        return null;
    }

    @Override
    public Program openProgram(DomainFile df, int version) {
        return null;
    }

    @Override
    public Program openProgram(DomainFile domainFile, int version, int state) {
        return null;
    }

    @Override
    public void openProgram(Program program) {
    }

    @Override
    public void openProgram(Program program, int state) {
    }

    @Override
    public void releaseProgram(Program program, Object persistentOwner) {
    }

    @Override
    public void saveProgram() {
    }

    @Override
    public void saveProgram(Program program) {
    }

    @Override
    public void saveProgramAs() {
    }

    @Override
    public void saveProgramAs(Program program) {
    }

    @Override
    public void setCurrentProgram(Program p) {
    }

    @Override
    public boolean setPersistentOwner(Program program, Object owner) {
        return false;
    }

    public void setSearchPriority(Program p, int priority) {
    }
}

