/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.widgets.GenericDateCellRenderer;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import generic.theme.Gui;
import ghidra.app.plugin.core.label.LabelHistoryListener;
import ghidra.app.plugin.core.label.LabelHistoryTableModel;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.LabelHistory;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class LabelHistoryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private LabelHistoryTableModel tableModel;
    private JTable historyTable;
    private LabelHistoryListener listener;
    private boolean showAddresses;
    private final Program program;

    LabelHistoryPanel(Program program, List<LabelHistory> list, LabelHistoryListener listener) {
        super(new BorderLayout());
        this.program = program;
        this.showAddresses = listener != null;
        this.listener = listener;
        this.create(list);
    }

    void setCurrentAddress(List<LabelHistory> list) {
        this.tableModel = new LabelHistoryTableModel(list, true);
    }

    private void create(List<LabelHistory> list) {
        this.tableModel = new LabelHistoryTableModel(list, this.showAddresses);
        this.historyTable = new GhidraTable((TableModel)((Object)this.tableModel));
        JScrollPane sp = new JScrollPane(this.historyTable);
        Dimension d = new Dimension(this.showAddresses ? 600 : 520, 200);
        this.historyTable.setPreferredScrollableViewportSize(d);
        this.historyTable.setSelectionMode(0);
        this.add((Component)sp, "Center");
        TableColumnModel columnModel = this.historyTable.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            String name = (String)column.getIdentifier();
            if (name.equals("Modification Date")) {
                column.setCellRenderer((TableCellRenderer)new GenericDateCellRenderer());
                column.setPreferredWidth(190);
                continue;
            }
            if (name.equals("Label")) {
                column.setPreferredWidth(280);
                column.setCellRenderer((TableCellRenderer)((Object)new LabelCellRenderer()));
                continue;
            }
            if (name.equals("Address")) {
                column.setPreferredWidth(130);
                continue;
            }
            if (!name.equals("User")) continue;
            column.setPreferredWidth(190);
        }
        this.historyTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    LabelHistoryPanel.this.handleMouseClicked();
                }
            }
        });
    }

    private void handleMouseClicked() {
        if (this.listener == null) {
            return;
        }
        for (LabelHistory h : this.tableModel.getLastSelectedObjects()) {
            this.listener.addressSelected(this.program, h.getAddress());
        }
    }

    private class LabelCellRenderer
    extends GTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Font monoFont;

        private LabelCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Component c = super.getTableCellRendererComponent(data);
            c.setFont(Gui.getFont((String)"font.monospaced"));
            return c;
        }
    }
}

