/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.Tricore_ElfRelocationType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.NotFoundException;

public class Tricore_ElfRelocationHandler
extends AbstractElfRelocationHandler<Tricore_ElfRelocationType, ElfRelocationContext<?>> {
    public Tricore_ElfRelocationHandler() {
        super(Tricore_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 44;
    }

    public int getRelrRelocationType() {
        return Tricore_ElfRelocationType.R_TRICORE_RELATIVE.typeId;
    }

    protected RelocationResult relocate(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, Tricore_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        long addend = relocation.hasAddend() ? relocation.getAddend() : (long)memory.getInt(relocationAddress);
        long offset = relocationAddress.getOffset();
        int symbolIndex = relocation.getSymbolIndex();
        long rv = 0L;
        int byteLength = -1;
        switch (type) {
            case R_TRICORE_RELATIVE: {
                long base = program.getImageBase().getOffset();
                rv = (int)(base + addend);
                byteLength = this.relocate_word32(memory, relocationAddress, rv);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_TRICORE_COPY: {
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, sym.getSize(), elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case R_TRICORE_BITPOS: {
                return RelocationResult.SKIPPED;
            }
        }
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        switch (type) {
            case R_TRICORE_32REL: {
                rv = symbolValue + addend - offset;
                byteLength = this.relocate_word32(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_32ABS: {
                rv = symbolValue + addend;
                byteLength = this.relocate_word32(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_24REL: {
                rv = symbolValue + addend - offset;
                byteLength = this.relocate_relB(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_24ABS: {
                rv = symbolValue + addend;
                byteLength = this.relocate_absB(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_HI: {
                rv = symbolValue + addend + 32768L >> 16;
                byteLength = this.relocate_RLC(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_LO: {
                rv = symbolValue + addend & 0xFFFFL;
                byteLength = this.relocate_RLC(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_LO2: {
                rv = symbolValue + addend & 0xFFFFL;
                byteLength = this.relocate_BOL(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_18ABS: {
                rv = symbolValue + addend;
                byteLength = this.relocate_ABS(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_15REL: {
                rv = symbolValue + addend - offset;
                byteLength = this.relocate_BR(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_16OFF: {
                rv = symbolValue + addend;
                byteLength = this.relocate_BOL(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_3POS: {
                rv = symbolValue + addend;
                byteLength = this.relocate_3POS(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_5POS: {
                rv = symbolValue + addend;
                byteLength = this.relocate_5POS(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_PCPHI: {
                rv = symbolValue + addend >> 16;
                byteLength = this.relocate_word16(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_PCPLO: {
                rv = symbolValue + addend & 0xFFFFL;
                byteLength = this.relocate_word16(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_PCPPAGE: {
                rv = symbolValue + addend & 0xFF00L;
                byteLength = this.relocate_pcpPage(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_PCPOFF: {
                rv = symbolValue + addend >> 2 & 0x3FL;
                byteLength = this.relocate_PI(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_PCPTEXT: {
                rv = symbolValue + addend >> 1 & 0xFFFFL;
                byteLength = this.relocate_word16(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_5POS2: {
                rv = symbolValue + addend;
                byteLength = this.relocate_5POS2(memory, relocationAddress, rv);
                break;
            }
            case R_TRICORE_GLOB_DAT: 
            case R_TRICORE_JMP_SLOT: {
                memory.setInt(relocationAddress, (int)symbolValue);
                break;
            }
        }
        if (byteLength <= 0) {
            this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
            return RelocationResult.UNSUPPORTED;
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }

    private int relocate_word32(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        memory.setInt(relocationAddress, (int)rv);
        return 4;
    }

    private int relocate_word16(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        memory.setShort(relocationAddress, (short)rv);
        return 2;
    }

    private int relocate_relB(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 1L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getInt(relocationAddress) & 0xFF;
        iw = (int)((long)iw | (val & 0x1FFFEL) << 15);
        iw = (int)((long)iw | (val & 0x1FE0000L) >> 9);
        memory.setInt(relocationAddress, iw);
        return 4;
    }

    private int relocate_absB(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 266338305L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getInt(relocationAddress) & 0xFF;
        iw = (int)((long)iw | (val & 0x1FFFEL) << 15);
        iw = (int)((long)iw | (val & 0x1E0000L) >> 9);
        iw = (int)((long)iw | (val & 0xFFFFFFFFF0000000L) >> 16);
        memory.setInt(relocationAddress, iw);
        return 4;
    }

    private int relocate_BO(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 0xFFFFFC00L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getInt(relocationAddress) & 0xFC0FFFF;
        iw = (int)((long)iw | (val & 0x3FL) << 16);
        iw = (int)((long)iw | (val & 0x3C0L) << 22);
        memory.setInt(relocationAddress, iw);
        return 4;
    }

    private int relocate_BOL(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 0xFFFF0000L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getInt(relocationAddress) & 0xFFFF;
        iw = (int)((long)iw | (val & 0x3FL) << 16);
        iw = (int)((long)iw | (val & 0x3C0L) << 22);
        iw = (int)((long)iw | (val & 0xFC00L) << 12);
        memory.setInt(relocationAddress, iw);
        return 4;
    }

    private int relocate_BR(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 0xFFFF0000L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getInt(relocationAddress) & 0x8000FFFF;
        iw = (int)((long)iw | (val & 0xFFFEL) << 15);
        memory.setInt(relocationAddress, iw);
        return 4;
    }

    private int relocate_RLC(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 0xFFFF0000L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getInt(relocationAddress) & 0xF0000FFF;
        iw = (int)((long)iw | (val & 0xFFFFL) << 12);
        memory.setInt(relocationAddress, iw);
        return 4;
    }

    private int relocate_ABS(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 0xFFFC000L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getInt(relocationAddress) & 0xC000FFF;
        iw = (int)((long)iw | (val & 0x3FL) << 16);
        iw = (int)((long)iw | (val & 0x3C0L) << 22);
        iw = (int)((long)iw | (val & 0x3C00L) << 12);
        iw = (int)((long)iw | (val & 0xFFFFFFFFF0000000L) >> 16);
        memory.setInt(relocationAddress, iw);
        return 4;
    }

    private int relocate_SBR(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException, NotFoundException {
        long mask = 0xFFFFFFF0L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        throw new NotFoundException();
    }

    private int relocate_pcpPage(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 0xFFFF00FFL;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getShort(relocationAddress) & 0xFF;
        iw = (int)((long)iw | val & 0xFF00L);
        memory.setShort(relocationAddress, (short)iw);
        return 2;
    }

    private int relocate_PI(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 0xFFFFFFC0L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getShort(relocationAddress) & 0xFFC0;
        iw = (int)((long)iw | val & 0x3FL);
        memory.setShort(relocationAddress, (short)iw);
        return 2;
    }

    private int relocate_3POS(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 0xFFFFFFF8L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getInt(relocationAddress);
        iw = (int)((long)iw | val << 8);
        memory.setInt(relocationAddress, iw);
        return 4;
    }

    private int relocate_5POS(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 0xFFFFFFE0L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getInt(relocationAddress);
        iw = (int)((long)iw | val << 16);
        memory.setInt(relocationAddress, iw);
        return 4;
    }

    private int relocate_5POS2(Memory memory, Address relocationAddress, long rv) throws MemoryAccessException {
        long mask = 0xFFFFFFE0L;
        long val = (mask ^ 0xFFFFFFFFFFFFFFFFL) & rv;
        int iw = memory.getInt(relocationAddress);
        iw = (int)((long)iw | val << 23);
        memory.setInt(relocationAddress, iw);
        return 4;
    }
}

