/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.collections.CaseInsensitiveDictionary;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.JdbcEscapeFunctionDescriptor;
import org.hibernate.query.sqm.function.MultipatternSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.NamedFunctionDescriptorBuilder;
import org.hibernate.query.sqm.produce.function.NamedSetReturningFunctionDescriptorBuilder;
import org.hibernate.query.sqm.produce.function.PatternFunctionDescriptorBuilder;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmFunctionRegistry {
    private final CaseInsensitiveDictionary<SqmFunctionDescriptor> functionMap = new CaseInsensitiveDictionary();
    private final CaseInsensitiveDictionary<SqmSetReturningFunctionDescriptor> setReturningFunctionMap = new CaseInsensitiveDictionary();
    private final CaseInsensitiveDictionary<String> alternateKeyMap = new CaseInsensitiveDictionary();

    public Set<String> getValidFunctionKeys() {
        return this.functionMap.unmodifiableKeySet();
    }

    public Stream<Map.Entry<String, SqmFunctionDescriptor>> getFunctionsByName() {
        TreeMap<String, SqmFunctionDescriptor> sortedFunctionMap = new TreeMap<String, SqmFunctionDescriptor>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, SqmFunctionDescriptor> entry : this.functionMap.unmodifiableEntrySet()) {
            sortedFunctionMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.alternateKeyMap.unmodifiableEntrySet()) {
            sortedFunctionMap.put(entry.getKey(), this.functionMap.get((String)entry.getValue()));
        }
        return sortedFunctionMap.entrySet().stream();
    }

    public Stream<Map.Entry<String, SqmSetReturningFunctionDescriptor>> getSetReturningFunctionsByName() {
        TreeMap<String, SqmSetReturningFunctionDescriptor> sortedFunctionMap = new TreeMap<String, SqmSetReturningFunctionDescriptor>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, SqmSetReturningFunctionDescriptor> entry : this.setReturningFunctionMap.unmodifiableEntrySet()) {
            sortedFunctionMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.alternateKeyMap.unmodifiableEntrySet()) {
            sortedFunctionMap.put(entry.getKey(), this.setReturningFunctionMap.get((String)entry.getValue()));
        }
        return sortedFunctionMap.entrySet().stream();
    }

    public @Nullable SqmFunctionDescriptor findFunctionDescriptor(String functionName) {
        SqmFunctionDescriptor found = null;
        String alternateKeyResolution = this.alternateKeyMap.get(functionName);
        if (alternateKeyResolution != null) {
            found = this.functionMap.get(alternateKeyResolution);
        }
        if (found == null) {
            found = this.functionMap.get(functionName);
        }
        return found;
    }

    public @Nullable SqmSetReturningFunctionDescriptor findSetReturningFunctionDescriptor(String functionName) {
        SqmSetReturningFunctionDescriptor found = null;
        String alternateKeyResolution = this.alternateKeyMap.get(functionName);
        if (alternateKeyResolution != null) {
            found = this.setReturningFunctionMap.get(alternateKeyResolution);
        }
        if (found == null) {
            found = this.setReturningFunctionMap.get(functionName);
        }
        return found;
    }

    public SqmFunctionDescriptor register(String registrationKey, SqmFunctionDescriptor function) {
        SqmFunctionDescriptor priorRegistration = this.functionMap.put(registrationKey, function);
        this.alternateKeyMap.remove(registrationKey);
        return function;
    }

    public SqmSetReturningFunctionDescriptor register(String registrationKey, SqmSetReturningFunctionDescriptor function) {
        SqmSetReturningFunctionDescriptor priorRegistration = this.setReturningFunctionMap.put(registrationKey, function);
        this.alternateKeyMap.remove(registrationKey);
        return function;
    }

    public SqmFunctionDescriptor registerPattern(String name, String pattern) {
        return this.patternDescriptorBuilder(name, pattern).register();
    }

    public SqmFunctionDescriptor registerPattern(String name, String pattern, BasicType returnType) {
        return this.patternDescriptorBuilder(name, pattern).setInvariantType(returnType).register();
    }

    public PatternFunctionDescriptorBuilder patternDescriptorBuilder(String registrationKey, String pattern) {
        return new PatternFunctionDescriptorBuilder(this, registrationKey, FunctionKind.NORMAL, pattern);
    }

    public PatternFunctionDescriptorBuilder patternAggregateDescriptorBuilder(String registrationKey, String pattern) {
        return new PatternFunctionDescriptorBuilder(this, registrationKey, FunctionKind.AGGREGATE, pattern);
    }

    public SqmFunctionDescriptor registerNamed(String name) {
        return this.namedDescriptorBuilder(name).register();
    }

    public SqmFunctionDescriptor registerNamed(String name, BasicType returnType) {
        return this.namedDescriptorBuilder(name, name).setInvariantType(returnType).register();
    }

    public NamedFunctionDescriptorBuilder namedDescriptorBuilder(String name) {
        return this.namedDescriptorBuilder(name, name);
    }

    public NamedFunctionDescriptorBuilder namedAggregateDescriptorBuilder(String name) {
        return this.namedAggregateDescriptorBuilder(name, name);
    }

    public NamedFunctionDescriptorBuilder namedOrderedSetAggregateDescriptorBuilder(String name) {
        return this.namedOrderedSetAggregateDescriptorBuilder(name, name);
    }

    public NamedFunctionDescriptorBuilder namedWindowDescriptorBuilder(String name) {
        return this.namedWindowDescriptorBuilder(name, name);
    }

    public NamedSetReturningFunctionDescriptorBuilder namedSetReturningDescriptorBuilder(String name, SetReturningFunctionTypeResolver typeResolver) {
        return this.namedSetReturningDescriptorBuilder(name, name, typeResolver);
    }

    public NamedFunctionDescriptorBuilder namedDescriptorBuilder(String registrationKey, String name) {
        return new NamedFunctionDescriptorBuilder(this, registrationKey, FunctionKind.NORMAL, name);
    }

    public NamedFunctionDescriptorBuilder namedAggregateDescriptorBuilder(String registrationKey, String name) {
        return new NamedFunctionDescriptorBuilder(this, registrationKey, FunctionKind.AGGREGATE, name);
    }

    public NamedFunctionDescriptorBuilder namedOrderedSetAggregateDescriptorBuilder(String registrationKey, String name) {
        return new NamedFunctionDescriptorBuilder(this, registrationKey, FunctionKind.ORDERED_SET_AGGREGATE, name);
    }

    public NamedFunctionDescriptorBuilder namedWindowDescriptorBuilder(String registrationKey, String name) {
        return new NamedFunctionDescriptorBuilder(this, registrationKey, FunctionKind.WINDOW, name);
    }

    public NamedSetReturningFunctionDescriptorBuilder namedSetReturningDescriptorBuilder(String registrationKey, String name, SetReturningFunctionTypeResolver typeResolver) {
        return new NamedSetReturningFunctionDescriptorBuilder(this, registrationKey, name, typeResolver);
    }

    public NamedFunctionDescriptorBuilder noArgsBuilder(String name) {
        return this.noArgsBuilder(name, name);
    }

    public NamedFunctionDescriptorBuilder noArgsBuilder(String registrationKey, String name) {
        return this.namedDescriptorBuilder(registrationKey, name).setExactArgumentCount(0);
    }

    public SqmFunctionDescriptor registerNoArgs(String name) {
        return this.registerNoArgs(name, name);
    }

    public SqmFunctionDescriptor registerNoArgs(String registrationKey, String name) {
        return this.noArgsBuilder(registrationKey, name).register();
    }

    public SqmFunctionDescriptor registerNoArgs(String name, BasicType returnType) {
        return this.registerNoArgs(name, name, returnType);
    }

    public SqmFunctionDescriptor registerNoArgs(String registrationKey, String name, BasicType returnType) {
        return this.noArgsBuilder(registrationKey, name).setInvariantType(returnType).register();
    }

    public SqmFunctionDescriptor wrapInJdbcEscape(String name, SqmFunctionDescriptor wrapped) {
        JdbcEscapeFunctionDescriptor wrapperTemplate = new JdbcEscapeFunctionDescriptor(name, wrapped);
        this.register(name, wrapperTemplate);
        return wrapperTemplate;
    }

    public void registerAlternateKey(String alternateKey, String mappedKey) {
        assert (this.functionMap.containsKey(mappedKey));
        this.alternateKeyMap.put(alternateKey, mappedKey);
    }

    public MultipatternSqmFunctionDescriptor registerNullaryUnaryPattern(String name, BasicType type, String pattern0, String pattern1, FunctionParameterType parameterType, TypeConfiguration typeConfiguration) {
        return this.registerPatterns(name, type, new FunctionParameterType[]{parameterType}, typeConfiguration, pattern0, pattern1);
    }

    public MultipatternSqmFunctionDescriptor registerUnaryBinaryPattern(String name, String pattern1, String pattern2, FunctionParameterType parameterType1, FunctionParameterType parameterType2, TypeConfiguration typeConfiguration) {
        return this.registerPatterns(name, new FunctionParameterType[]{parameterType1, parameterType2}, typeConfiguration, null, pattern1, pattern2);
    }

    public MultipatternSqmFunctionDescriptor registerUnaryBinaryPattern(String name, BasicType<?> type, String pattern1, String pattern2, FunctionParameterType parameterType1, FunctionParameterType parameterType2, TypeConfiguration typeConfiguration) {
        return this.registerPatterns(name, type, new FunctionParameterType[]{parameterType1, parameterType2}, typeConfiguration, null, pattern1, pattern2);
    }

    public MultipatternSqmFunctionDescriptor registerBinaryTernaryPattern(String name, BasicType<?> type, String pattern2, String pattern3, FunctionParameterType parameterType1, FunctionParameterType parameterType2, FunctionParameterType parameterType3, TypeConfiguration typeConfiguration) {
        return this.registerPatterns(name, type, new FunctionParameterType[]{parameterType1, parameterType2, parameterType3}, typeConfiguration, null, null, pattern2, pattern3);
    }

    public MultipatternSqmFunctionDescriptor registerTernaryQuaternaryPattern(String name, BasicType<?> type, String pattern3, String pattern4, FunctionParameterType parameterType1, FunctionParameterType parameterType2, FunctionParameterType parameterType3, FunctionParameterType parameterType4, TypeConfiguration typeConfiguration) {
        return this.registerPatterns(name, type, new FunctionParameterType[]{parameterType1, parameterType2, parameterType3, parameterType4}, typeConfiguration, null, null, null, pattern3, pattern4);
    }

    private MultipatternSqmFunctionDescriptor registerPatterns(String name, FunctionParameterType[] parameterTypes, TypeConfiguration typeConfiguration, String ... patterns) {
        SqmFunctionDescriptor[] descriptors = new SqmFunctionDescriptor[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = patterns[i];
            if (pattern == null) continue;
            descriptors[i] = this.patternDescriptorBuilder(name, pattern).setExactArgumentCount(i).setParameterTypes(parameterTypes).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).descriptor();
        }
        MultipatternSqmFunctionDescriptor function = new MultipatternSqmFunctionDescriptor(name, descriptors, typeConfiguration, parameterTypes);
        this.register(name, function);
        return function;
    }

    private MultipatternSqmFunctionDescriptor registerPatterns(String name, BasicType<?> type, FunctionParameterType[] parameterTypes, TypeConfiguration typeConfiguration, String ... patterns) {
        SqmFunctionDescriptor[] descriptors = new SqmFunctionDescriptor[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = patterns[i];
            if (pattern == null) continue;
            descriptors[i] = this.patternDescriptorBuilder(name, pattern).setExactArgumentCount(i).setParameterTypes(parameterTypes).setInvariantType(type).descriptor();
        }
        MultipatternSqmFunctionDescriptor function = new MultipatternSqmFunctionDescriptor(name, descriptors, type, typeConfiguration, parameterTypes);
        this.register(name, function);
        return function;
    }

    public void overlay(SqmFunctionRegistry registryToOverly) {
        this.functionMap.forEach(registryToOverly::register);
        this.alternateKeyMap.forEach(registryToOverly::registerAlternateKey);
    }

    public void close() {
        this.functionMap.clear();
        this.alternateKeyMap.clear();
    }
}

