/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BatchScoreBulkScorer;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreScorerSupplier;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TermMatchesIterator;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.IOSupplier;

public class TermQuery
extends Query {
    private final Term term;
    private final TermStates perReaderTermState;

    public TermQuery(Term t) {
        this.term = Objects.requireNonNull(t);
        this.perReaderTermState = null;
    }

    public TermQuery(Term t, TermStates states) {
        assert (states != null);
        this.term = Objects.requireNonNull(t);
        this.perReaderTermState = Objects.requireNonNull(states);
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        IndexReaderContext context = searcher.getTopReaderContext();
        TermStates termState = this.perReaderTermState == null || !this.perReaderTermState.wasBuiltFor(context) ? TermStates.build(searcher, this.term, scoreMode.needsScores()) : this.perReaderTermState;
        return new TermWeight(searcher, scoreMode, boost, termState);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.term.field())) {
            visitor.consumeTerms(this, this.term);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        return buffer.toString();
    }

    public TermStates getTermStates() {
        return this.perReaderTermState;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.term.equals(((TermQuery)other).term);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.term.hashCode();
    }

    final class TermWeight
    extends Weight {
        private final Similarity similarity;
        private final Similarity.SimScorer simScorer;
        private final TermStates termStates;
        private final ScoreMode scoreMode;

        public TermWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost, TermStates termStates) throws IOException {
            TermStatistics termStats;
            CollectionStatistics collectionStats;
            super(TermQuery.this);
            if (scoreMode.needsScores() && termStates == null) {
                throw new IllegalStateException("termStates are required when scores are needed");
            }
            this.scoreMode = scoreMode;
            this.termStates = termStates;
            this.similarity = searcher.getSimilarity();
            if (scoreMode.needsScores()) {
                collectionStats = searcher.collectionStatistics(TermQuery.this.term.field());
                termStats = termStates.docFreq() > 0 ? searcher.termStatistics(TermQuery.this.term, termStates.docFreq(), termStates.totalTermFreq()) : null;
            } else {
                collectionStats = new CollectionStatistics(TermQuery.this.term.field(), 1L, 1L, 1L, 1L);
                termStats = new TermStatistics(TermQuery.this.term.bytes(), 1L, 1L);
            }
            this.simScorer = termStats == null ? null : (scoreMode.needsScores() ? this.similarity.scorer(boost, collectionStats, termStats) : new Similarity.SimScorer(this){

                @Override
                public float score(float freq, long norm) {
                    return 0.0f;
                }
            });
        }

        @Override
        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            TermsEnum te = this.getTermsEnum(context);
            if (te == null) {
                return null;
            }
            return MatchesUtils.forField(TermQuery.this.term.field(), () -> {
                PostingsEnum pe = te.postings(null, 56);
                if (pe.advance(doc) != doc) {
                    return null;
                }
                return new TermMatchesIterator(this.getQuery(), pe);
            });
        }

        public String toString() {
            return "weight(" + String.valueOf(TermQuery.this) + ")";
        }

        @Override
        public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
            assert (this.termStates == null || this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext(context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + String.valueOf(ReaderUtil.getTopLevelContext(context));
            final IOSupplier<TermState> stateSupplier = this.termStates.get(context);
            if (stateSupplier == null) {
                return null;
            }
            return new ScorerSupplier(){
                private TermsEnum termsEnum;
                private boolean topLevelScoringClause = false;

                private TermsEnum getTermsEnum() throws IOException {
                    if (this.termsEnum == null) {
                        TermState state = (TermState)stateSupplier.get();
                        if (state == null) {
                            return null;
                        }
                        this.termsEnum = context.reader().terms(TermQuery.this.term.field()).iterator();
                        this.termsEnum.seekExact(TermQuery.this.term.bytes(), state);
                    }
                    return this.termsEnum;
                }

                @Override
                public Scorer get(long leadCost) throws IOException {
                    TermsEnum termsEnum = this.getTermsEnum();
                    if (termsEnum == null) {
                        return new ConstantScoreScorer(0.0f, TermWeight.this.scoreMode, DocIdSetIterator.empty());
                    }
                    NumericDocValues norms = null;
                    if (TermWeight.this.scoreMode.needsScores()) {
                        norms = context.reader().getNormValues(TermQuery.this.term.field());
                    }
                    if (TermWeight.this.scoreMode == ScoreMode.TOP_SCORES) {
                        return new TermScorer(termsEnum.impacts(8), TermWeight.this.simScorer, norms, this.topLevelScoringClause);
                    }
                    int flags = TermWeight.this.scoreMode.needsScores() ? 8 : 0;
                    return new TermScorer(termsEnum.postings(null, flags), TermWeight.this.simScorer, norms);
                }

                @Override
                public BulkScorer bulkScorer() throws IOException {
                    if (!TermWeight.this.scoreMode.needsScores()) {
                        DocIdSetIterator iterator = this.get(Long.MAX_VALUE).iterator();
                        int maxDoc = context.reader().maxDoc();
                        return ConstantScoreScorerSupplier.fromIterator(iterator, 0.0f, TermWeight.this.scoreMode, maxDoc).bulkScorer();
                    }
                    return new BatchScoreBulkScorer(this.get(Long.MAX_VALUE));
                }

                @Override
                public long cost() {
                    try {
                        TermsEnum te = this.getTermsEnum();
                        return te == null ? 0L : (long)te.docFreq();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                @Override
                public void setTopLevelScoringClause() throws IOException {
                    this.topLevelScoringClause = true;
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        private TermsEnum getTermsEnum(LeafReaderContext context) throws IOException {
            TermState state;
            assert (this.termStates != null);
            assert (this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext(context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + String.valueOf(ReaderUtil.getTopLevelContext(context));
            IOSupplier<TermState> supplier = this.termStates.get(context);
            TermState termState = state = supplier == null ? null : supplier.get();
            if (state == null) {
                assert (this.termNotInReader(context.reader(), TermQuery.this.term)) : "no termstate found but term exists in reader term=" + String.valueOf(TermQuery.this.term);
                return null;
            }
            TermsEnum termsEnum = context.reader().terms(TermQuery.this.term.field()).iterator();
            termsEnum.seekExact(TermQuery.this.term.bytes(), state);
            return termsEnum;
        }

        private boolean termNotInReader(LeafReader reader, Term term) throws IOException {
            return reader.docFreq(term) == 0;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            Scorer scorer = this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq = ((TermScorer)scorer).freq();
                NumericDocValues norms = context.reader().getNormValues(TermQuery.this.term.field());
                long norm = 1L;
                if (norms != null && norms.advanceExact(doc)) {
                    norm = norms.longValue();
                }
                Explanation freqExplanation = Explanation.match((Number)Float.valueOf(freq), "freq, occurrences of term within document", new Explanation[0]);
                Explanation scoreExplanation = this.simScorer.explain(freqExplanation, norm);
                return Explanation.match(scoreExplanation.getValue(), "weight(" + String.valueOf(this.getQuery()) + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
            }
            return Explanation.noMatch("no matching term", new Explanation[0]);
        }

        @Override
        public int count(LeafReaderContext context) throws IOException {
            if (!context.reader().hasDeletions()) {
                TermsEnum termsEnum = this.getTermsEnum(context);
                if (termsEnum != null) {
                    return termsEnum.docFreq();
                }
                return 0;
            }
            return super.count(context);
        }
    }
}

