/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.common;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.core.common.Strings;

public class ParameterValidator {
    private static final int MAX_DATASOURCE_NAME_BYTES = 127;

    public List<String> validateDatasourceName(String datasourceName) {
        int byteCount;
        ArrayList<String> errorMsgs = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)datasourceName)) {
            errorMsgs.add("datasource name must not be empty");
            return errorMsgs;
        }
        if (!Strings.validFileName((String)datasourceName)) {
            errorMsgs.add(String.format(Locale.ROOT, "datasource name must not contain the following characters %s", Strings.INVALID_FILENAME_CHARS));
        }
        if (datasourceName.contains("#")) {
            errorMsgs.add("datasource name must not contain '#'");
        }
        if (datasourceName.contains(":")) {
            errorMsgs.add("datasource name must not contain ':'");
        }
        if (datasourceName.charAt(0) == '_' || datasourceName.charAt(0) == '-' || datasourceName.charAt(0) == '+') {
            errorMsgs.add("datasource name must not start with '_', '-', or '+'");
        }
        if ((byteCount = datasourceName.getBytes(StandardCharsets.UTF_8).length) > 127) {
            errorMsgs.add(String.format(Locale.ROOT, "datasource name is too long, (%d > %d)", byteCount, 127));
        }
        if (datasourceName.equals(".") || datasourceName.equals("..")) {
            errorMsgs.add("datasource name must not be '.' or '..'");
        }
        return errorMsgs;
    }
}

