/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.Arrays;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Unbox;
import org.apache.poi.logging.PoiLogManager;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public class NilPICFAndBinData {
    private static final Logger LOGGER = PoiLogManager.getLogger(NilPICFAndBinData.class);
    private static final int MAX_SIZE = 100000;
    private byte[] _binData;

    public NilPICFAndBinData(byte[] data, int offset) {
        this.fillFields(data, offset);
    }

    public void fillFields(byte[] data, int offset) {
        int lcb = LittleEndian.getInt((byte[])data, (int)offset);
        int cbHeader = LittleEndian.getUShort((byte[])data, (int)(offset + 4));
        if (cbHeader != 68) {
            LOGGER.atWarn().log("NilPICFAndBinData at offset {} cbHeader 0x{} != 0x44", (Object)Unbox.box((int)offset), (Object)Integer.toHexString(cbHeader));
        }
        IOUtils.safelyAllocateCheck((long)lcb, (int)100000);
        IOUtils.safelyAllocateCheck((long)cbHeader, (int)100000);
        int binaryLength = lcb - cbHeader;
        this._binData = Arrays.copyOfRange(data, offset + cbHeader, offset + cbHeader + binaryLength);
    }

    public byte[] getBinData() {
        return this._binData;
    }

    public byte[] serialize() {
        byte[] bs = new byte[this._binData.length + 68];
        LittleEndian.putInt((byte[])bs, (int)0, (int)(this._binData.length + 68));
        System.arraycopy(this._binData, 0, bs, 68, this._binData.length);
        return bs;
    }

    public int serialize(byte[] data, int offset) {
        LittleEndian.putInt((byte[])data, (int)offset, (int)(this._binData.length + 68));
        System.arraycopy(this._binData, 0, data, offset + 68, this._binData.length);
        return 68 + this._binData.length;
    }
}

