//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_USD_IMAGING_USD_SKEL_IMAGING_RESOLVED_SKELETON_SCHEMA_H
#define PXR_USD_IMAGING_USD_SKEL_IMAGING_RESOLVED_SKELETON_SCHEMA_H

/// \file

#include "pxr/usdImaging/usdSkelImaging/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define USD_SKEL_IMAGING_RESOLVED_SKELETON_SCHEMA_TOKENS \
    (resolvedSkeleton) \
    (skelLocalToCommonSpace) \
    (skinningTransforms) \
    (blendShapes) \
    (blendShapeWeights) \

TF_DECLARE_PUBLIC_TOKENS(UsdSkelImagingResolvedSkeletonSchemaTokens, USDSKELIMAGING_API,
    USD_SKEL_IMAGING_RESOLVED_SKELETON_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


/// \class UsdSkelImagingResolvedSkeletonSchema
///
/// Resolved data for a skeleton and the targeted skelAnim. Populated by the
/// skeleton resolving scene index.
///
class UsdSkelImagingResolvedSkeletonSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    UsdSkelImagingResolvedSkeletonSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "resolvedSkeleton" from the parent container and constructs a
    /// UsdSkelImagingResolvedSkeletonSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    USDSKELIMAGING_API
    static UsdSkelImagingResolvedSkeletonSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    /// Transform to go from the local space if the skeleton prim to common
    /// space (as defined by UsdSkelImagingDataSourceXformResolver).
    USDSKELIMAGING_API
    HdMatrixDataSourceHandle GetSkelLocalToCommonSpace() const;

    /// Passed to the extComputations. Computed from the following: skeleton's
    /// joints (determining the topology), and bind and rest (if needed)
    /// transforms. skelAnim's joints (determining the remapping) and
    /// translations, rotations and scales.
    USDSKELIMAGING_API
    HdMatrix4fArrayDataSourceHandle GetSkinningTransforms() const;

    /// Just forwarded from the skelAnim's blendShapes.
    USDSKELIMAGING_API
    HdTokenArrayDataSourceHandle GetBlendShapes() const;

    /// Just forwarded from the skelAnim's blendShapeWeights.
    USDSKELIMAGING_API
    HdFloatArrayDataSourceHandle GetBlendShapeWeights() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    USDSKELIMAGING_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate skelLocalToCommonSpace.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetSkelLocalToCommonSpaceLocator();

    /// Prim-level relative data source locator to locate skinningTransforms.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetSkinningTransformsLocator();

    /// Prim-level relative data source locator to locate blendShapes.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetBlendShapesLocator();

    /// Prim-level relative data source locator to locate blendShapeWeights.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetBlendShapeWeightsLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    USDSKELIMAGING_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdMatrixDataSourceHandle &skelLocalToCommonSpace,
        const HdMatrix4fArrayDataSourceHandle &skinningTransforms,
        const HdTokenArrayDataSourceHandle &blendShapes,
        const HdFloatArrayDataSourceHandle &blendShapeWeights
    );

    /// \class UsdSkelImagingResolvedSkeletonSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        USDSKELIMAGING_API
        Builder &SetSkelLocalToCommonSpace(
            const HdMatrixDataSourceHandle &skelLocalToCommonSpace);
        USDSKELIMAGING_API
        Builder &SetSkinningTransforms(
            const HdMatrix4fArrayDataSourceHandle &skinningTransforms);
        USDSKELIMAGING_API
        Builder &SetBlendShapes(
            const HdTokenArrayDataSourceHandle &blendShapes);
        USDSKELIMAGING_API
        Builder &SetBlendShapeWeights(
            const HdFloatArrayDataSourceHandle &blendShapeWeights);

        /// Returns a container data source containing the members set thus far.
        USDSKELIMAGING_API
        HdContainerDataSourceHandle Build();

    private:
        HdMatrixDataSourceHandle _skelLocalToCommonSpace;
        HdMatrix4fArrayDataSourceHandle _skinningTransforms;
        HdTokenArrayDataSourceHandle _blendShapes;
        HdFloatArrayDataSourceHandle _blendShapeWeights;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif