﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/serverlessrepo/ServerlessApplicationRepository_EXPORTS.h>
#include <aws/serverlessrepo/model/VersionSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ServerlessApplicationRepository {
namespace Model {
class ListApplicationVersionsResult {
 public:
  AWS_SERVERLESSAPPLICATIONREPOSITORY_API ListApplicationVersionsResult() = default;
  AWS_SERVERLESSAPPLICATIONREPOSITORY_API ListApplicationVersionsResult(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SERVERLESSAPPLICATIONREPOSITORY_API ListApplicationVersionsResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The token to request the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListApplicationVersionsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of version summaries for the application.</p>
   */
  inline const Aws::Vector<VersionSummary>& GetVersions() const { return m_versions; }
  template <typename VersionsT = Aws::Vector<VersionSummary>>
  void SetVersions(VersionsT&& value) {
    m_versionsHasBeenSet = true;
    m_versions = std::forward<VersionsT>(value);
  }
  template <typename VersionsT = Aws::Vector<VersionSummary>>
  ListApplicationVersionsResult& WithVersions(VersionsT&& value) {
    SetVersions(std::forward<VersionsT>(value));
    return *this;
  }
  template <typename VersionsT = VersionSummary>
  ListApplicationVersionsResult& AddVersions(VersionsT&& value) {
    m_versionsHasBeenSet = true;
    m_versions.emplace_back(std::forward<VersionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListApplicationVersionsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::Vector<VersionSummary> m_versions;
  bool m_versionsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ServerlessApplicationRepository
}  // namespace Aws
