﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace imagebuilder {
namespace Model {

/**
 * <p>Identifies an Amazon EC2 launch template to use for a specific
 * account.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/LaunchTemplateConfiguration">AWS
 * API Reference</a></p>
 */
class LaunchTemplateConfiguration {
 public:
  AWS_IMAGEBUILDER_API LaunchTemplateConfiguration() = default;
  AWS_IMAGEBUILDER_API LaunchTemplateConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_IMAGEBUILDER_API LaunchTemplateConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IMAGEBUILDER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Identifies the Amazon EC2 launch template to use.</p>
   */
  inline const Aws::String& GetLaunchTemplateId() const { return m_launchTemplateId; }
  inline bool LaunchTemplateIdHasBeenSet() const { return m_launchTemplateIdHasBeenSet; }
  template <typename LaunchTemplateIdT = Aws::String>
  void SetLaunchTemplateId(LaunchTemplateIdT&& value) {
    m_launchTemplateIdHasBeenSet = true;
    m_launchTemplateId = std::forward<LaunchTemplateIdT>(value);
  }
  template <typename LaunchTemplateIdT = Aws::String>
  LaunchTemplateConfiguration& WithLaunchTemplateId(LaunchTemplateIdT&& value) {
    SetLaunchTemplateId(std::forward<LaunchTemplateIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The account ID that this configuration applies to.</p>
   */
  inline const Aws::String& GetAccountId() const { return m_accountId; }
  inline bool AccountIdHasBeenSet() const { return m_accountIdHasBeenSet; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  LaunchTemplateConfiguration& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Set the specified Amazon EC2 launch template as the default launch template
   * for the specified account.</p>
   */
  inline bool GetSetDefaultVersion() const { return m_setDefaultVersion; }
  inline bool SetDefaultVersionHasBeenSet() const { return m_setDefaultVersionHasBeenSet; }
  inline void SetSetDefaultVersion(bool value) {
    m_setDefaultVersionHasBeenSet = true;
    m_setDefaultVersion = value;
  }
  inline LaunchTemplateConfiguration& WithSetDefaultVersion(bool value) {
    SetSetDefaultVersion(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_launchTemplateId;

  Aws::String m_accountId;

  bool m_setDefaultVersion{false};
  bool m_launchTemplateIdHasBeenSet = false;
  bool m_accountIdHasBeenSet = false;
  bool m_setDefaultVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace imagebuilder
}  // namespace Aws
