# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.policy.v2023_04_01.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.policy.v2023_04_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class Identity(_serialization.Model):
    """Identity for the resource.  Policy assignments support a maximum of one identity.  That is
    either a system assigned identity or a single user assigned identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the resource identity.  This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the resource identity.  This property will only be provided
     for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The identity type. This is the only required field when adding a system or user
     assigned identity to a resource. Known values are: "SystemAssigned", "UserAssigned", and
     "None".
    :vartype type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.ResourceIdentityType
    :ivar user_assigned_identities: The user identity associated with the policy. The user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.resource.policy.v2023_04_01.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentitiesValue}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentitiesValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The identity type. This is the only required field when adding a system or user
         assigned identity to a resource. Known values are: "SystemAssigned", "UserAssigned", and
         "None".
        :paramtype type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.ResourceIdentityType
        :keyword user_assigned_identities: The user identity associated with the policy. The user
         identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.resource.policy.v2023_04_01.models.UserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class NonComplianceMessage(_serialization.Model):
    """A message that describes why a resource is non-compliant with the policy. This is shown in
    'deny' error messages and on resource's non-compliant compliance results.

    All required parameters must be populated in order to send to server.

    :ivar message: A message that describes why a resource is non-compliant with the policy. This
     is shown in 'deny' error messages and on resource's non-compliant compliance results. Required.
    :vartype message: str
    :ivar policy_definition_reference_id: The policy definition reference ID within a policy set
     definition the message is intended for. This is only applicable if the policy assignment
     assigns a policy set definition. If this is not provided the message applies to all policies
     assigned by this policy assignment.
    :vartype policy_definition_reference_id: str
    """

    _validation = {
        "message": {"required": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
    }

    def __init__(self, *, message: str, policy_definition_reference_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword message: A message that describes why a resource is non-compliant with the policy.
         This is shown in 'deny' error messages and on resource's non-compliant compliance results.
         Required.
        :paramtype message: str
        :keyword policy_definition_reference_id: The policy definition reference ID within a policy set
         definition the message is intended for. This is only applicable if the policy assignment
         assigns a policy set definition. If this is not provided the message applies to all policies
         assigned by this policy assignment.
        :paramtype policy_definition_reference_id: str
        """
        super().__init__(**kwargs)
        self.message = message
        self.policy_definition_reference_id = policy_definition_reference_id


class Override(_serialization.Model):
    """The policy property value override.

    :ivar kind: The override kind. "policyEffect"
    :vartype kind: str or ~azure.mgmt.resource.policy.v2023_04_01.models.OverrideKind
    :ivar value: The value to override the policy property.
    :vartype value: str
    :ivar selectors: The list of the selector expressions.
    :vartype selectors: list[~azure.mgmt.resource.policy.v2023_04_01.models.Selector]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "selectors": {"key": "selectors", "type": "[Selector]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.OverrideKind"]] = None,
        value: Optional[str] = None,
        selectors: Optional[List["_models.Selector"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The override kind. "policyEffect"
        :paramtype kind: str or ~azure.mgmt.resource.policy.v2023_04_01.models.OverrideKind
        :keyword value: The value to override the policy property.
        :paramtype value: str
        :keyword selectors: The list of the selector expressions.
        :paramtype selectors: list[~azure.mgmt.resource.policy.v2023_04_01.models.Selector]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.value = value
        self.selectors = selectors


class ParameterDefinitionsValue(_serialization.Model):
    """The definition of a parameter that can be provided to the policy.

    :ivar type: The data type of the parameter. Known values are: "String", "Array", "Object",
     "Boolean", "Integer", "Float", and "DateTime".
    :vartype type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterType
    :ivar allowed_values: The allowed values for the parameter.
    :vartype allowed_values: list[JSON]
    :ivar default_value: The default value for the parameter if no value is provided.
    :vartype default_value: JSON
    :ivar schema: Provides validation of parameter inputs during assignment using a self-defined
     JSON schema. This property is only supported for object-type parameters and follows the
     Json.NET Schema 2019-09 implementation. You can learn more about using schemas at
     https://json-schema.org/ and test draft schemas at https://www.jsonschemavalidator.net/.
    :vartype schema: JSON
    :ivar metadata: General metadata for the parameter.
    :vartype metadata:
     ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterDefinitionsValueMetadata
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "allowed_values": {"key": "allowedValues", "type": "[object]"},
        "default_value": {"key": "defaultValue", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "metadata": {"key": "metadata", "type": "ParameterDefinitionsValueMetadata"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ParameterType"]] = None,
        allowed_values: Optional[List[JSON]] = None,
        default_value: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        metadata: Optional["_models.ParameterDefinitionsValueMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The data type of the parameter. Known values are: "String", "Array", "Object",
         "Boolean", "Integer", "Float", and "DateTime".
        :paramtype type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterType
        :keyword allowed_values: The allowed values for the parameter.
        :paramtype allowed_values: list[JSON]
        :keyword default_value: The default value for the parameter if no value is provided.
        :paramtype default_value: JSON
        :keyword schema: Provides validation of parameter inputs during assignment using a self-defined
         JSON schema. This property is only supported for object-type parameters and follows the
         Json.NET Schema 2019-09 implementation. You can learn more about using schemas at
         https://json-schema.org/ and test draft schemas at https://www.jsonschemavalidator.net/.
        :paramtype schema: JSON
        :keyword metadata: General metadata for the parameter.
        :paramtype metadata:
         ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterDefinitionsValueMetadata
        """
        super().__init__(**kwargs)
        self.type = type
        self.allowed_values = allowed_values
        self.default_value = default_value
        self.schema = schema
        self.metadata = metadata


class ParameterDefinitionsValueMetadata(_serialization.Model):
    """General metadata for the parameter.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar display_name: The display name for the parameter.
    :vartype display_name: str
    :ivar description: The description of the parameter.
    :vartype description: str
    :ivar strong_type: Used when assigning the policy definition through the portal. Provides a
     context aware list of values for the user to choose from.
    :vartype strong_type: str
    :ivar assign_permissions: Set to true to have Azure portal create role assignments on the
     resource ID or resource scope value of this parameter during policy assignment. This property
     is useful in case you wish to assign permissions outside the assignment scope.
    :vartype assign_permissions: bool
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "strong_type": {"key": "strongType", "type": "str"},
        "assign_permissions": {"key": "assignPermissions", "type": "bool"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        strong_type: Optional[str] = None,
        assign_permissions: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword display_name: The display name for the parameter.
        :paramtype display_name: str
        :keyword description: The description of the parameter.
        :paramtype description: str
        :keyword strong_type: Used when assigning the policy definition through the portal. Provides a
         context aware list of values for the user to choose from.
        :paramtype strong_type: str
        :keyword assign_permissions: Set to true to have Azure portal create role assignments on the
         resource ID or resource scope value of this parameter during policy assignment. This property
         is useful in case you wish to assign permissions outside the assignment scope.
        :paramtype assign_permissions: bool
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.display_name = display_name
        self.description = description
        self.strong_type = strong_type
        self.assign_permissions = assign_permissions


class ParameterValuesValue(_serialization.Model):
    """The value of a parameter.

    :ivar value: The value of the parameter.
    :vartype value: JSON
    """

    _attribute_map = {
        "value": {"key": "value", "type": "object"},
    }

    def __init__(self, *, value: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword value: The value of the parameter.
        :paramtype value: JSON
        """
        super().__init__(**kwargs)
        self.value = value


class PolicyAssignment(_serialization.Model):
    """The policy assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy assignment.
    :vartype id: str
    :ivar type: The type of the policy assignment.
    :vartype type: str
    :ivar name: The name of the policy assignment.
    :vartype name: str
    :ivar location: The location of the policy assignment. Only required when utilizing managed
     identity.
    :vartype location: str
    :ivar identity: The managed identity associated with the policy assignment.
    :vartype identity: ~azure.mgmt.resource.policy.v2023_04_01.models.Identity
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.v2023_04_01.models.SystemData
    :ivar display_name: The display name of the policy assignment.
    :vartype display_name: str
    :ivar policy_definition_id: The ID of the policy definition or policy set definition being
     assigned.
    :vartype policy_definition_id: str
    :ivar definition_version: The version of the policy definition to use.
    :vartype definition_version: str
    :ivar latest_definition_version: The latest version of the policy definition available. This is
     only present if requested via the $expand query parameter.
    :vartype latest_definition_version: str
    :ivar effective_definition_version: The effective version of the policy definition in use. This
     is only present if requested via the $expand query parameter.
    :vartype effective_definition_version: str
    :ivar scope: The scope for the policy assignment.
    :vartype scope: str
    :ivar not_scopes: The policy's excluded scopes.
    :vartype not_scopes: list[str]
    :ivar parameters: The parameter values for the assigned policy rule. The keys are the parameter
     names.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterValuesValue]
    :ivar description: This message will be part of response in case of policy violation.
    :vartype description: str
    :ivar metadata: The policy assignment metadata. Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar enforcement_mode: The policy assignment enforcement mode. Possible values are Default and
     DoNotEnforce. Known values are: "Default" and "DoNotEnforce".
    :vartype enforcement_mode: str or
     ~azure.mgmt.resource.policy.v2023_04_01.models.EnforcementMode
    :ivar non_compliance_messages: The messages that describe why a resource is non-compliant with
     the policy.
    :vartype non_compliance_messages:
     list[~azure.mgmt.resource.policy.v2023_04_01.models.NonComplianceMessage]
    :ivar resource_selectors: The resource selector list to filter policies by resource properties.
    :vartype resource_selectors:
     list[~azure.mgmt.resource.policy.v2023_04_01.models.ResourceSelector]
    :ivar overrides: The policy property value override.
    :vartype overrides: list[~azure.mgmt.resource.policy.v2023_04_01.models.Override]
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "latest_definition_version": {"readonly": True},
        "effective_definition_version": {"readonly": True},
        "scope": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "policy_definition_id": {"key": "properties.policyDefinitionId", "type": "str"},
        "definition_version": {"key": "properties.definitionVersion", "type": "str"},
        "latest_definition_version": {"key": "properties.latestDefinitionVersion", "type": "str"},
        "effective_definition_version": {"key": "properties.effectiveDefinitionVersion", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "not_scopes": {"key": "properties.notScopes", "type": "[str]"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterValuesValue}"},
        "description": {"key": "properties.description", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "enforcement_mode": {"key": "properties.enforcementMode", "type": "str"},
        "non_compliance_messages": {"key": "properties.nonComplianceMessages", "type": "[NonComplianceMessage]"},
        "resource_selectors": {"key": "properties.resourceSelectors", "type": "[ResourceSelector]"},
        "overrides": {"key": "properties.overrides", "type": "[Override]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["_models.Identity"] = None,
        display_name: Optional[str] = None,
        policy_definition_id: Optional[str] = None,
        definition_version: Optional[str] = None,
        not_scopes: Optional[List[str]] = None,
        parameters: Optional[Dict[str, "_models.ParameterValuesValue"]] = None,
        description: Optional[str] = None,
        metadata: Optional[JSON] = None,
        enforcement_mode: Union[str, "_models.EnforcementMode"] = "Default",
        non_compliance_messages: Optional[List["_models.NonComplianceMessage"]] = None,
        resource_selectors: Optional[List["_models.ResourceSelector"]] = None,
        overrides: Optional[List["_models.Override"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the policy assignment. Only required when utilizing managed
         identity.
        :paramtype location: str
        :keyword identity: The managed identity associated with the policy assignment.
        :paramtype identity: ~azure.mgmt.resource.policy.v2023_04_01.models.Identity
        :keyword display_name: The display name of the policy assignment.
        :paramtype display_name: str
        :keyword policy_definition_id: The ID of the policy definition or policy set definition being
         assigned.
        :paramtype policy_definition_id: str
        :keyword definition_version: The version of the policy definition to use.
        :paramtype definition_version: str
        :keyword not_scopes: The policy's excluded scopes.
        :paramtype not_scopes: list[str]
        :keyword parameters: The parameter values for the assigned policy rule. The keys are the
         parameter names.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterValuesValue]
        :keyword description: This message will be part of response in case of policy violation.
        :paramtype description: str
        :keyword metadata: The policy assignment metadata. Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword enforcement_mode: The policy assignment enforcement mode. Possible values are Default
         and DoNotEnforce. Known values are: "Default" and "DoNotEnforce".
        :paramtype enforcement_mode: str or
         ~azure.mgmt.resource.policy.v2023_04_01.models.EnforcementMode
        :keyword non_compliance_messages: The messages that describe why a resource is non-compliant
         with the policy.
        :paramtype non_compliance_messages:
         list[~azure.mgmt.resource.policy.v2023_04_01.models.NonComplianceMessage]
        :keyword resource_selectors: The resource selector list to filter policies by resource
         properties.
        :paramtype resource_selectors:
         list[~azure.mgmt.resource.policy.v2023_04_01.models.ResourceSelector]
        :keyword overrides: The policy property value override.
        :paramtype overrides: list[~azure.mgmt.resource.policy.v2023_04_01.models.Override]
        """
        super().__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.location = location
        self.identity = identity
        self.system_data = None
        self.display_name = display_name
        self.policy_definition_id = policy_definition_id
        self.definition_version = definition_version
        self.latest_definition_version = None
        self.effective_definition_version = None
        self.scope = None
        self.not_scopes = not_scopes
        self.parameters = parameters
        self.description = description
        self.metadata = metadata
        self.enforcement_mode = enforcement_mode
        self.non_compliance_messages = non_compliance_messages
        self.resource_selectors = resource_selectors
        self.overrides = overrides


class PolicyAssignmentListResult(_serialization.Model):
    """List of policy assignments.

    :ivar value: An array of policy assignments.
    :vartype value: list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyAssignment]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PolicyAssignment"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of policy assignments.
        :paramtype value: list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyAssignment]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyAssignmentUpdate(_serialization.Model):
    """The policy assignment for Patch request.

    :ivar location: The location of the policy assignment. Only required when utilizing managed
     identity.
    :vartype location: str
    :ivar identity: The managed identity associated with the policy assignment.
    :vartype identity: ~azure.mgmt.resource.policy.v2023_04_01.models.Identity
    :ivar resource_selectors: The resource selector list to filter policies by resource properties.
    :vartype resource_selectors:
     list[~azure.mgmt.resource.policy.v2023_04_01.models.ResourceSelector]
    :ivar overrides: The policy property value override.
    :vartype overrides: list[~azure.mgmt.resource.policy.v2023_04_01.models.Override]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "resource_selectors": {"key": "properties.resourceSelectors", "type": "[ResourceSelector]"},
        "overrides": {"key": "properties.overrides", "type": "[Override]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["_models.Identity"] = None,
        resource_selectors: Optional[List["_models.ResourceSelector"]] = None,
        overrides: Optional[List["_models.Override"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the policy assignment. Only required when utilizing managed
         identity.
        :paramtype location: str
        :keyword identity: The managed identity associated with the policy assignment.
        :paramtype identity: ~azure.mgmt.resource.policy.v2023_04_01.models.Identity
        :keyword resource_selectors: The resource selector list to filter policies by resource
         properties.
        :paramtype resource_selectors:
         list[~azure.mgmt.resource.policy.v2023_04_01.models.ResourceSelector]
        :keyword overrides: The policy property value override.
        :paramtype overrides: list[~azure.mgmt.resource.policy.v2023_04_01.models.Override]
        """
        super().__init__(**kwargs)
        self.location = location
        self.identity = identity
        self.resource_selectors = resource_selectors
        self.overrides = overrides


class PolicyDefinition(_serialization.Model):
    """The policy definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy definition.
    :vartype id: str
    :ivar name: The name of the policy definition.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policyDefinitions).
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.v2023_04_01.models.SystemData
    :ivar policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
     Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.PolicyType
    :ivar mode: The policy definition mode. Some examples are All, Indexed,
     Microsoft.KeyVault.Data.
    :vartype mode: str
    :ivar display_name: The display name of the policy definition.
    :vartype display_name: str
    :ivar description: The policy definition description.
    :vartype description: str
    :ivar policy_rule: The policy rule.
    :vartype policy_rule: JSON
    :ivar metadata: The policy definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar parameters: The parameter definitions for parameters used in the policy rule. The keys
     are the parameter names.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterDefinitionsValue]
    :ivar version: The policy definition version in #.#.# format.
    :vartype version: str
    :ivar versions: A list of available versions for this policy definition.
    :vartype versions: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "policy_type": {"key": "properties.policyType", "type": "str"},
        "mode": {"key": "properties.mode", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "policy_rule": {"key": "properties.policyRule", "type": "object"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterDefinitionsValue}"},
        "version": {"key": "properties.version", "type": "str"},
        "versions": {"key": "properties.versions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "_models.PolicyType"]] = None,
        mode: str = "Indexed",
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        policy_rule: Optional[JSON] = None,
        metadata: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterDefinitionsValue"]] = None,
        version: Optional[str] = None,
        versions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
         Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.PolicyType
        :keyword mode: The policy definition mode. Some examples are All, Indexed,
         Microsoft.KeyVault.Data.
        :paramtype mode: str
        :keyword display_name: The display name of the policy definition.
        :paramtype display_name: str
        :keyword description: The policy definition description.
        :paramtype description: str
        :keyword policy_rule: The policy rule.
        :paramtype policy_rule: JSON
        :keyword metadata: The policy definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword parameters: The parameter definitions for parameters used in the policy rule. The keys
         are the parameter names.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterDefinitionsValue]
        :keyword version: The policy definition version in #.#.# format.
        :paramtype version: str
        :keyword versions: A list of available versions for this policy definition.
        :paramtype versions: list[str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None
        self.policy_type = policy_type
        self.mode = mode
        self.display_name = display_name
        self.description = description
        self.policy_rule = policy_rule
        self.metadata = metadata
        self.parameters = parameters
        self.version = version
        self.versions = versions


class PolicyDefinitionGroup(_serialization.Model):
    """The policy definition group.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the group. Required.
    :vartype name: str
    :ivar display_name: The group's display name.
    :vartype display_name: str
    :ivar category: The group's category.
    :vartype category: str
    :ivar description: The group's description.
    :vartype description: str
    :ivar additional_metadata_id: A resource ID of a resource that contains additional metadata
     about the group.
    :vartype additional_metadata_id: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "additional_metadata_id": {"key": "additionalMetadataId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        display_name: Optional[str] = None,
        category: Optional[str] = None,
        description: Optional[str] = None,
        additional_metadata_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the group. Required.
        :paramtype name: str
        :keyword display_name: The group's display name.
        :paramtype display_name: str
        :keyword category: The group's category.
        :paramtype category: str
        :keyword description: The group's description.
        :paramtype description: str
        :keyword additional_metadata_id: A resource ID of a resource that contains additional metadata
         about the group.
        :paramtype additional_metadata_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.category = category
        self.description = description
        self.additional_metadata_id = additional_metadata_id


class PolicyDefinitionListResult(_serialization.Model):
    """List of policy definitions.

    :ivar value: An array of policy definitions.
    :vartype value: list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PolicyDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of policy definitions.
        :paramtype value: list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyDefinitionReference(_serialization.Model):
    """The policy definition reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar policy_definition_id: The ID of the policy definition or policy set definition. Required.
    :vartype policy_definition_id: str
    :ivar definition_version: The version of the policy definition to use.
    :vartype definition_version: str
    :ivar latest_definition_version: The latest version of the policy definition available. This is
     only present if requested via the $expand query parameter.
    :vartype latest_definition_version: str
    :ivar effective_definition_version: The effective version of the policy definition in use. This
     is only present if requested via the $expand query parameter.
    :vartype effective_definition_version: str
    :ivar parameters: The parameter values for the referenced policy rule. The keys are the
     parameter names.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterValuesValue]
    :ivar policy_definition_reference_id: A unique id (within the policy set definition) for this
     policy definition reference.
    :vartype policy_definition_reference_id: str
    :ivar group_names: The name of the groups that this policy definition reference belongs to.
    :vartype group_names: list[str]
    """

    _validation = {
        "policy_definition_id": {"required": True},
        "latest_definition_version": {"readonly": True},
        "effective_definition_version": {"readonly": True},
    }

    _attribute_map = {
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "definition_version": {"key": "definitionVersion", "type": "str"},
        "latest_definition_version": {"key": "latestDefinitionVersion", "type": "str"},
        "effective_definition_version": {"key": "effectiveDefinitionVersion", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterValuesValue}"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
        "group_names": {"key": "groupNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        policy_definition_id: str,
        definition_version: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterValuesValue"]] = None,
        policy_definition_reference_id: Optional[str] = None,
        group_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_definition_id: The ID of the policy definition or policy set definition.
         Required.
        :paramtype policy_definition_id: str
        :keyword definition_version: The version of the policy definition to use.
        :paramtype definition_version: str
        :keyword parameters: The parameter values for the referenced policy rule. The keys are the
         parameter names.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterValuesValue]
        :keyword policy_definition_reference_id: A unique id (within the policy set definition) for
         this policy definition reference.
        :paramtype policy_definition_reference_id: str
        :keyword group_names: The name of the groups that this policy definition reference belongs to.
        :paramtype group_names: list[str]
        """
        super().__init__(**kwargs)
        self.policy_definition_id = policy_definition_id
        self.definition_version = definition_version
        self.latest_definition_version = None
        self.effective_definition_version = None
        self.parameters = parameters
        self.policy_definition_reference_id = policy_definition_reference_id
        self.group_names = group_names


class PolicyDefinitionVersion(_serialization.Model):
    """The ID of the policy definition version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy definition version.
    :vartype id: str
    :ivar name: The name of the policy definition version.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policyDefinitions/versions).
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.v2023_04_01.models.SystemData
    :ivar policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
     Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.PolicyType
    :ivar mode: The policy definition mode. Some examples are All, Indexed,
     Microsoft.KeyVault.Data.
    :vartype mode: str
    :ivar display_name: The display name of the policy definition.
    :vartype display_name: str
    :ivar description: The policy definition description.
    :vartype description: str
    :ivar policy_rule: The policy rule.
    :vartype policy_rule: JSON
    :ivar metadata: The policy definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar parameters: The parameter definitions for parameters used in the policy rule. The keys
     are the parameter names.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterDefinitionsValue]
    :ivar version: The policy definition version in #.#.# format.
    :vartype version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "policy_type": {"key": "properties.policyType", "type": "str"},
        "mode": {"key": "properties.mode", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "policy_rule": {"key": "properties.policyRule", "type": "object"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterDefinitionsValue}"},
        "version": {"key": "properties.version", "type": "str"},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "_models.PolicyType"]] = None,
        mode: str = "Indexed",
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        policy_rule: Optional[JSON] = None,
        metadata: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterDefinitionsValue"]] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
         Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.PolicyType
        :keyword mode: The policy definition mode. Some examples are All, Indexed,
         Microsoft.KeyVault.Data.
        :paramtype mode: str
        :keyword display_name: The display name of the policy definition.
        :paramtype display_name: str
        :keyword description: The policy definition description.
        :paramtype description: str
        :keyword policy_rule: The policy rule.
        :paramtype policy_rule: JSON
        :keyword metadata: The policy definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword parameters: The parameter definitions for parameters used in the policy rule. The keys
         are the parameter names.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterDefinitionsValue]
        :keyword version: The policy definition version in #.#.# format.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None
        self.policy_type = policy_type
        self.mode = mode
        self.display_name = display_name
        self.description = description
        self.policy_rule = policy_rule
        self.metadata = metadata
        self.parameters = parameters
        self.version = version


class PolicyDefinitionVersionListResult(_serialization.Model):
    """List of policy definition versions.

    :ivar value: An array of policy definitions versions.
    :vartype value: list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinitionVersion]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyDefinitionVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PolicyDefinitionVersion"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of policy definitions versions.
        :paramtype value: list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinitionVersion]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicySetDefinition(_serialization.Model):
    """The policy set definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy set definition.
    :vartype id: str
    :ivar name: The name of the policy set definition.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policySetDefinitions).
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.v2023_04_01.models.SystemData
    :ivar policy_type: The type of policy set definition. Possible values are NotSpecified,
     BuiltIn, Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and
     "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.PolicyType
    :ivar display_name: The display name of the policy set definition.
    :vartype display_name: str
    :ivar description: The policy set definition description.
    :vartype description: str
    :ivar metadata: The policy set definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar parameters: The policy set definition parameters that can be used in policy definition
     references.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterDefinitionsValue]
    :ivar policy_definitions: An array of policy definition references.
    :vartype policy_definitions:
     list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinitionReference]
    :ivar policy_definition_groups: The metadata describing groups of policy definition references
     within the policy set definition.
    :vartype policy_definition_groups:
     list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinitionGroup]
    :ivar version: The policy set definition version in #.#.# format.
    :vartype version: str
    :ivar versions: A list of available versions for this policy set definition.
    :vartype versions: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "policy_type": {"key": "properties.policyType", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterDefinitionsValue}"},
        "policy_definitions": {"key": "properties.policyDefinitions", "type": "[PolicyDefinitionReference]"},
        "policy_definition_groups": {"key": "properties.policyDefinitionGroups", "type": "[PolicyDefinitionGroup]"},
        "version": {"key": "properties.version", "type": "str"},
        "versions": {"key": "properties.versions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "_models.PolicyType"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        metadata: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterDefinitionsValue"]] = None,
        policy_definitions: Optional[List["_models.PolicyDefinitionReference"]] = None,
        policy_definition_groups: Optional[List["_models.PolicyDefinitionGroup"]] = None,
        version: Optional[str] = None,
        versions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_type: The type of policy set definition. Possible values are NotSpecified,
         BuiltIn, Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and
         "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.PolicyType
        :keyword display_name: The display name of the policy set definition.
        :paramtype display_name: str
        :keyword description: The policy set definition description.
        :paramtype description: str
        :keyword metadata: The policy set definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword parameters: The policy set definition parameters that can be used in policy definition
         references.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterDefinitionsValue]
        :keyword policy_definitions: An array of policy definition references.
        :paramtype policy_definitions:
         list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinitionReference]
        :keyword policy_definition_groups: The metadata describing groups of policy definition
         references within the policy set definition.
        :paramtype policy_definition_groups:
         list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinitionGroup]
        :keyword version: The policy set definition version in #.#.# format.
        :paramtype version: str
        :keyword versions: A list of available versions for this policy set definition.
        :paramtype versions: list[str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None
        self.policy_type = policy_type
        self.display_name = display_name
        self.description = description
        self.metadata = metadata
        self.parameters = parameters
        self.policy_definitions = policy_definitions
        self.policy_definition_groups = policy_definition_groups
        self.version = version
        self.versions = versions


class PolicySetDefinitionListResult(_serialization.Model):
    """List of policy set definitions.

    :ivar value: An array of policy set definitions.
    :vartype value: list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicySetDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicySetDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PolicySetDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of policy set definitions.
        :paramtype value: list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicySetDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicySetDefinitionVersion(_serialization.Model):
    """The policy set definition version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy set definition version.
    :vartype id: str
    :ivar name: The name of the policy set definition version.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policySetDefinitions/versions).
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.v2023_04_01.models.SystemData
    :ivar policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
     Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.PolicyType
    :ivar display_name: The display name of the policy set definition.
    :vartype display_name: str
    :ivar description: The policy set definition description.
    :vartype description: str
    :ivar metadata: The policy set definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar parameters: The policy set definition parameters that can be used in policy definition
     references.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterDefinitionsValue]
    :ivar policy_definitions: An array of policy definition references.
    :vartype policy_definitions:
     list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinitionReference]
    :ivar policy_definition_groups: The metadata describing groups of policy definition references
     within the policy set definition.
    :vartype policy_definition_groups:
     list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinitionGroup]
    :ivar version: The policy set definition version in #.#.# format.
    :vartype version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "policy_type": {"key": "properties.policyType", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterDefinitionsValue}"},
        "policy_definitions": {"key": "properties.policyDefinitions", "type": "[PolicyDefinitionReference]"},
        "policy_definition_groups": {"key": "properties.policyDefinitionGroups", "type": "[PolicyDefinitionGroup]"},
        "version": {"key": "properties.version", "type": "str"},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "_models.PolicyType"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        metadata: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterDefinitionsValue"]] = None,
        policy_definitions: Optional[List["_models.PolicyDefinitionReference"]] = None,
        policy_definition_groups: Optional[List["_models.PolicyDefinitionGroup"]] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
         Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.PolicyType
        :keyword display_name: The display name of the policy set definition.
        :paramtype display_name: str
        :keyword description: The policy set definition description.
        :paramtype description: str
        :keyword metadata: The policy set definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword parameters: The policy set definition parameters that can be used in policy definition
         references.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2023_04_01.models.ParameterDefinitionsValue]
        :keyword policy_definitions: An array of policy definition references.
        :paramtype policy_definitions:
         list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinitionReference]
        :keyword policy_definition_groups: The metadata describing groups of policy definition
         references within the policy set definition.
        :paramtype policy_definition_groups:
         list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicyDefinitionGroup]
        :keyword version: The policy set definition version in #.#.# format.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None
        self.policy_type = policy_type
        self.display_name = display_name
        self.description = description
        self.metadata = metadata
        self.parameters = parameters
        self.policy_definitions = policy_definitions
        self.policy_definition_groups = policy_definition_groups
        self.version = version


class PolicySetDefinitionVersionListResult(_serialization.Model):
    """List of policy set definition versions.

    :ivar value: An array of policy set definition versions.
    :vartype value: list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicySetDefinitionVersion]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicySetDefinitionVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PolicySetDefinitionVersion"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of policy set definition versions.
        :paramtype value:
         list[~azure.mgmt.resource.policy.v2023_04_01.models.PolicySetDefinitionVersion]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceSelector(_serialization.Model):
    """The resource selector to filter policies by resource properties.

    :ivar name: The name of the resource selector.
    :vartype name: str
    :ivar selectors: The list of the selector expressions.
    :vartype selectors: list[~azure.mgmt.resource.policy.v2023_04_01.models.Selector]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "selectors": {"key": "selectors", "type": "[Selector]"},
    }

    def __init__(
        self, *, name: Optional[str] = None, selectors: Optional[List["_models.Selector"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the resource selector.
        :paramtype name: str
        :keyword selectors: The list of the selector expressions.
        :paramtype selectors: list[~azure.mgmt.resource.policy.v2023_04_01.models.Selector]
        """
        super().__init__(**kwargs)
        self.name = name
        self.selectors = selectors


class Selector(_serialization.Model):
    """The selector expression.

    :ivar kind: The selector kind. Known values are: "resourceLocation", "resourceType",
     "resourceWithoutLocation", and "policyDefinitionReferenceId".
    :vartype kind: str or ~azure.mgmt.resource.policy.v2023_04_01.models.SelectorKind
    :ivar in_property: The list of values to filter in.
    :vartype in_property: list[str]
    :ivar not_in: The list of values to filter out.
    :vartype not_in: list[str]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "in_property": {"key": "in", "type": "[str]"},
        "not_in": {"key": "notIn", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.SelectorKind"]] = None,
        in_property: Optional[List[str]] = None,
        not_in: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The selector kind. Known values are: "resourceLocation", "resourceType",
         "resourceWithoutLocation", and "policyDefinitionReferenceId".
        :paramtype kind: str or ~azure.mgmt.resource.policy.v2023_04_01.models.SelectorKind
        :keyword in_property: The list of values to filter in.
        :paramtype in_property: list[str]
        :keyword not_in: The list of values to filter out.
        :paramtype not_in: list[str]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.in_property = in_property
        self.not_in = not_in


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.resource.policy.v2023_04_01.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.resource.policy.v2023_04_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.resource.policy.v2023_04_01.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentitiesValue(_serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
