# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "sql mi start",
)
class Start(AAZCommand):
    """Start the managed instance.

    :example: Start a managed instance.
        az sql mi start --ids resourceId
        az sql mi start --mi miName -g resourceGroup --subscription subscription
    """

    _aaz_info = {
        "version": "2022-11-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.sql/managedinstances/{}/start", "2022-11-01-preview"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.managed_instance = AAZStrArg(
            options=["--mi", "--managed-instance"],
            help="The name of the managed instance.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            help="Name of the resource group.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.ManagedInstancesStart(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class ManagedInstancesStart(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/start",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "managedInstanceName", self.ctx.args.managed_instance,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-11-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.identity = AAZObjectType()
            _schema_on_200.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.sku = AAZObjectType()
            _schema_on_200.tags = AAZDictType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            identity = cls._schema_on_200.identity
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType()
            identity.user_assigned_identities = AAZDictType(
                serialized_name="userAssignedIdentities",
            )

            user_assigned_identities = cls._schema_on_200.identity.user_assigned_identities
            user_assigned_identities.Element = AAZObjectType()

            _element = cls._schema_on_200.identity.user_assigned_identities.Element
            _element.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.administrator_login = AAZStrType(
                serialized_name="administratorLogin",
            )
            properties.administrators = AAZObjectType()
            properties.collation = AAZStrType()
            properties.current_backup_storage_redundancy = AAZStrType(
                serialized_name="currentBackupStorageRedundancy",
                flags={"read_only": True},
            )
            properties.dns_zone = AAZStrType(
                serialized_name="dnsZone",
                flags={"read_only": True},
            )
            properties.fully_qualified_domain_name = AAZStrType(
                serialized_name="fullyQualifiedDomainName",
                flags={"read_only": True},
            )
            properties.instance_pool_id = AAZStrType(
                serialized_name="instancePoolId",
            )
            properties.key_id = AAZStrType(
                serialized_name="keyId",
            )
            properties.license_type = AAZStrType(
                serialized_name="licenseType",
            )
            properties.maintenance_configuration_id = AAZStrType(
                serialized_name="maintenanceConfigurationId",
            )
            properties.minimal_tls_version = AAZStrType(
                serialized_name="minimalTlsVersion",
            )
            properties.primary_user_assigned_identity_id = AAZStrType(
                serialized_name="primaryUserAssignedIdentityId",
            )
            properties.private_endpoint_connections = AAZListType(
                serialized_name="privateEndpointConnections",
                flags={"read_only": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.proxy_override = AAZStrType(
                serialized_name="proxyOverride",
            )
            properties.public_data_endpoint_enabled = AAZBoolType(
                serialized_name="publicDataEndpointEnabled",
            )
            properties.requested_backup_storage_redundancy = AAZStrType(
                serialized_name="requestedBackupStorageRedundancy",
            )
            properties.service_principal = AAZObjectType(
                serialized_name="servicePrincipal",
            )
            properties.state = AAZStrType(
                flags={"read_only": True},
            )
            properties.storage_size_in_gb = AAZIntType(
                serialized_name="storageSizeInGB",
            )
            properties.subnet_id = AAZStrType(
                serialized_name="subnetId",
            )
            properties.timezone_id = AAZStrType(
                serialized_name="timezoneId",
            )
            properties.v_cores = AAZIntType(
                serialized_name="vCores",
            )
            properties.virtual_cluster_id = AAZStrType(
                serialized_name="virtualClusterId",
                flags={"read_only": True},
            )
            properties.zone_redundant = AAZBoolType(
                serialized_name="zoneRedundant",
            )

            administrators = cls._schema_on_200.properties.administrators
            administrators.administrator_type = AAZStrType(
                serialized_name="administratorType",
            )
            administrators.azure_ad_only_authentication = AAZBoolType(
                serialized_name="azureADOnlyAuthentication",
            )
            administrators.login = AAZStrType()
            administrators.principal_type = AAZStrType(
                serialized_name="principalType",
            )
            administrators.sid = AAZStrType()
            administrators.tenant_id = AAZStrType(
                serialized_name="tenantId",
            )

            private_endpoint_connections = cls._schema_on_200.properties.private_endpoint_connections
            private_endpoint_connections.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.private_endpoint_connections.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType()

            properties = cls._schema_on_200.properties.private_endpoint_connections.Element.properties
            properties.private_endpoint = AAZObjectType(
                serialized_name="privateEndpoint",
            )
            properties.private_link_service_connection_state = AAZObjectType(
                serialized_name="privateLinkServiceConnectionState",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            private_endpoint = cls._schema_on_200.properties.private_endpoint_connections.Element.properties.private_endpoint
            private_endpoint.id = AAZStrType()

            private_link_service_connection_state = cls._schema_on_200.properties.private_endpoint_connections.Element.properties.private_link_service_connection_state
            private_link_service_connection_state.actions_required = AAZStrType(
                serialized_name="actionsRequired",
                flags={"read_only": True},
            )
            private_link_service_connection_state.description = AAZStrType(
                flags={"required": True},
            )
            private_link_service_connection_state.status = AAZStrType(
                flags={"required": True},
            )

            service_principal = cls._schema_on_200.properties.service_principal
            service_principal.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            service_principal.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            service_principal.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            service_principal.type = AAZStrType()

            sku = cls._schema_on_200.sku
            sku.capacity = AAZIntType()
            sku.family = AAZStrType()
            sku.name = AAZStrType(
                flags={"required": True},
            )
            sku.size = AAZStrType()
            sku.tier = AAZStrType()

            tags = cls._schema_on_200.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _StartHelper:
    """Helper class for Start"""


__all__ = ["Start"]
