/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.dependencies;

import java.util.Collection;
import java.util.Vector;
import org.freeplane.core.util.Pair;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.FormulaDependencies;
import org.freeplane.plugin.script.FormulaUtils;
import org.freeplane.plugin.script.dependencies.DependencySearchStrategy;
import org.freeplane.plugin.script.dependencies.RelatedElements;

class DependentsSearchStrategy
implements DependencySearchStrategy {
    DependentsSearchStrategy() {
    }

    @Override
    public RelatedElements find(NodeModel node) {
        return this.find(node, node);
    }

    @Override
    public RelatedElements find(NodeModel node, Attribute attribute) {
        return this.find(node, (Object)attribute);
    }

    private RelatedElements find(NodeModel node, Object element) {
        Iterable<NodeModel> possibleDependencies = FormulaDependencies.getPossibleDependencies(node);
        RelatedElements relatedElements = new RelatedElements(node);
        for (NodeModel candidate : possibleDependencies) {
            NodeAttributeTableModel attributeTableModel;
            Object userObject;
            Collection<Object> candidatePrecedents = FormulaUtils.getRelatedElements(candidate, userObject = candidate.getUserObject()).getElements();
            if (candidatePrecedents.contains(node)) {
                relatedElements.relateNode(candidate);
            }
            if ((attributeTableModel = (NodeAttributeTableModel)candidate.getExtension(NodeAttributeTableModel.class)) == null) continue;
            Vector attributes = attributeTableModel.getAttributes();
            attributes.stream().filter(a -> FormulaUtils.getRelatedElements(candidate, a.getValue()).getElements().contains(element)).forEach(a -> relatedElements.relateAttribute(candidate, (Attribute)a));
        }
        return relatedElements;
    }

    @Override
    public Pair<NodeModel, NodeModel> inConnectionOrder(Pair<NodeModel, NodeModel> nodePair) {
        return nodePair;
    }
}

