/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.main.application.AuxiliarySplitPanes;
import org.freeplane.main.application.AuxillaryEditorSplitPane;

class FrameComponentMover
implements IMapViewChangeListener,
PropertyChangeListener,
IFreeplanePropertyListener {
    private static final String SELECTED_MAP_FOLLOWS_ACTIVE_WINDOW = "selected_map_follows_active_window";
    private static final String UI_ELEMENTS_FOLLOW_SELECTED_MAP_PROPERTY = "ui_elements_follow_selected_map";
    private JFrame lastUIFrame = null;
    private boolean uiElementsFollowSelectedMap;

    public FrameComponentMover(JFrame frame) {
        this.lastUIFrame = frame;
        this.uiElementsFollowSelectedMap = this.uiElementsFollowSelectedMap();
    }

    public void installFocusListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusedWindow", this);
        ResourceController.getResourceController().addPropertyChangeListener((IFreeplanePropertyListener)this);
    }

    public void uninstall() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusedWindow", this);
    }

    void moveUIElements() {
        Window uiFrame = this.findUIFrame();
        this.afterUIWindowChange(uiFrame);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JComponent containedMapView;
        Window newFocusedWindow = (Window)evt.getNewValue();
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        JComponent selectedComponent = mapViewManager.getMapViewComponent();
        if (selectedComponent == (containedMapView = mapViewManager.getLastSelectedMapViewContainedIn((Component)newFocusedWindow))) {
            if (this.uiElementsFollowSelectedMap) {
                this.afterUIWindowChange(newFocusedWindow);
            }
        } else if (containedMapView != null && FrameComponentMover.selectedMapFollowsActiveWindow()) {
            mapViewManager.changeToMapView((Component)containedMapView);
        }
    }

    static boolean selectedMapFollowsActiveWindow() {
        return ResourceController.getResourceController().getBooleanProperty(SELECTED_MAP_FOLLOWS_ACTIVE_WINDOW);
    }

    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (propertyName.equals(UI_ELEMENTS_FOLLOW_SELECTED_MAP_PROPERTY)) {
            this.uiElementsFollowSelectedMap = Boolean.parseBoolean(newValue);
            Window menuWindow = this.findUIFrame();
            this.afterUIWindowChange(menuWindow);
        }
    }

    private Window findUIFrame() {
        return this.uiElementsFollowSelectedMap ? UITools.getCurrentFrame() : UITools.getFrame();
    }

    public void afterViewChange(Component oldView, Component newView) {
        if (newView != null && this.uiElementsFollowSelectedMap) {
            Window newFocusedWindow = SwingUtilities.getWindowAncestor(newView);
            this.afterUIWindowChange(newFocusedWindow);
        }
    }

    private boolean uiElementsFollowSelectedMap() {
        return ResourceController.getResourceController().getBooleanProperty(UI_ELEMENTS_FOLLOW_SELECTED_MAP_PROPERTY);
    }

    private void afterUIWindowChange(Window newFocusedWindow) {
        if (newFocusedWindow instanceof JFrame) {
            JFrame currentFrame = (JFrame)newFocusedWindow;
            if (this.lastUIFrame != null && this.lastUIFrame != currentFrame) {
                EventQueue.invokeLater(() -> this.moveNonCenterComponents(this.lastUIFrame, currentFrame));
            } else {
                this.lastUIFrame = currentFrame;
            }
        }
    }

    private void moveNonCenterComponents(JFrame fromFrame, JFrame toFrame) {
        if (toFrame != KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) {
            return;
        }
        this.moveMenuBar(fromFrame, toFrame);
        Container fromContentPane = fromFrame.getContentPane();
        Container toContentPane = toFrame.getContentPane();
        if (!(fromContentPane.getLayout() instanceof BorderLayout) || !(toContentPane.getLayout() instanceof BorderLayout)) {
            return;
        }
        this.moveComponentIfExists(fromContentPane, toContentPane, "North");
        this.moveComponentIfExists(fromContentPane, toContentPane, "South");
        this.moveComponentIfExists(fromContentPane, toContentPane, "East");
        this.moveComponentIfExists(fromContentPane, toContentPane, "West");
        this.moveAuxiliaryComponents(fromFrame, toFrame);
        fromContentPane.revalidate();
        fromContentPane.repaint();
        toContentPane.revalidate();
        toContentPane.repaint();
        this.lastUIFrame = toFrame;
    }

    private void moveMenuBar(JFrame fromFrame, JFrame toFrame) {
        JMenuBar menuBar = fromFrame.getJMenuBar();
        if (menuBar != null) {
            if (Compat.isMacOsX()) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                toFrame.setJMenuBar(menuBar);
                System.setProperty("apple.laf.useScreenMenuBar", "false");
            } else {
                toFrame.setJMenuBar(menuBar);
            }
        }
    }

    private void moveComponentIfExists(Container fromPane, Container toPane, String position) {
        BorderLayout fromLayout = (BorderLayout)fromPane.getLayout();
        Component component = fromLayout.getLayoutComponent(fromPane, position);
        if (component != null) {
            fromPane.remove(component);
            toPane.add(component, position);
        }
    }

    private void moveAuxiliaryComponents(JFrame fromFrame, JFrame toFrame) {
        AuxiliarySplitPanes fromSplitPanes = this.findAuxiliarySplitPanes(fromFrame);
        AuxiliarySplitPanes toSplitPanes = this.findAuxiliarySplitPanes(toFrame);
        if (fromSplitPanes != null && toSplitPanes != null) {
            EventQueue.invokeLater(() -> this.moveAuxiliaryComponentBetweenManagers(fromSplitPanes, toSplitPanes));
        }
    }

    private AuxiliarySplitPanes findAuxiliarySplitPanes(JFrame frame) {
        Component centerComponent;
        Container contentPane = frame.getContentPane();
        if (contentPane.getLayout() instanceof BorderLayout && (centerComponent = ((BorderLayout)contentPane.getLayout()).getLayoutComponent(contentPane, "Center")) instanceof AuxillaryEditorSplitPane) {
            AuxillaryEditorSplitPane rootPane = (AuxillaryEditorSplitPane)centerComponent;
            return rootPane.getManager();
        }
        return null;
    }

    private void moveAuxiliaryComponentBetweenManagers(AuxiliarySplitPanes fromManager, AuxiliarySplitPanes toManager) {
        String modeName = Controller.getCurrentModeController().getModeName();
        fromManager.moveAuxiliaryNoteTo(toManager, modeName);
    }

    public JFrame getUIFrame() {
        return this.lastUIFrame;
    }
}

