/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.dom.util;

import io.sf.carte.echosvg.util.CleanerThread;
import java.util.concurrent.locks.ReentrantLock;
import org.w3c.dom.Element;

public class DocumentDescriptor {
    protected static final int INITIAL_CAPACITY = 101;
    private final ReentrantLock tableLock = new ReentrantLock();
    protected Entry[] table = new Entry[101];
    protected int count;

    public int getNumberOfElements() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocationLine(Element elt) {
        this.tableLock.lock();
        try {
            int hash = elt.hashCode() & Integer.MAX_VALUE;
            int index = hash % this.table.length;
            Entry e = this.table[index];
            while (e != null) {
                Object o;
                if (e.hash == hash && (o = e.get()) == elt) {
                    int n = e.locationLine;
                    return n;
                }
                e = e.next;
            }
        }
        finally {
            this.tableLock.unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocationColumn(Element elt) {
        this.tableLock.lock();
        try {
            int hash = elt.hashCode() & Integer.MAX_VALUE;
            int index = hash % this.table.length;
            Entry e = this.table[index];
            while (e != null) {
                Object o;
                if (e.hash == hash && (o = e.get()) == elt) {
                    int n = e.locationColumn;
                    return n;
                }
                e = e.next;
            }
        }
        finally {
            this.tableLock.unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(Element elt, int line, int col) {
        this.tableLock.lock();
        try {
            Entry e;
            int hash = elt.hashCode() & Integer.MAX_VALUE;
            int index = hash % this.table.length;
            Entry e2 = this.table[index];
            while (e2 != null) {
                Object o;
                if (e2.hash == hash && (o = e2.get()) == elt) {
                    e2.locationLine = line;
                }
                e2 = e2.next;
            }
            int len = this.table.length;
            if (this.count++ >= len - (len >> 2)) {
                this.rehash();
                index = hash % this.table.length;
            }
            this.table[index] = e = new Entry(hash, elt, line, col, this.table[index]);
        }
        finally {
            this.tableLock.unlock();
        }
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        for (int i = oldTable.length - 1; i >= 0; --i) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = e.hash % this.table.length;
                e.next = this.table[index];
                this.table[index] = e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEntry(Entry e) {
        this.tableLock.lock();
        try {
            int hash = e.hash;
            int index = hash % this.table.length;
            Entry curr = this.table[index];
            if (curr == null) {
                return;
            }
            Entry prev = null;
            while (curr != e) {
                prev = curr;
                curr = curr.next;
            }
            if (prev == null) {
                this.table[index] = curr.next;
            } else {
                prev.next = curr.next;
            }
            --this.count;
        }
        finally {
            this.tableLock.unlock();
        }
    }

    protected class Entry
    extends CleanerThread.WeakReferenceCleared<Element> {
        public int hash;
        public int locationLine;
        public int locationColumn;
        public Entry next;

        public Entry(int hash, Element element, int locationLine, int locationColumn, Entry next) {
            super((Object)element);
            this.hash = hash;
            this.locationLine = locationLine;
            this.locationColumn = locationColumn;
            this.next = next;
        }

        public void cleared() {
            DocumentDescriptor.this.removeEntry(this);
        }
    }
}

