# frozen_string_literal: true

class AddSavedViewFkToUserSavedViews < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!
  milestone '18.7'

  def up
    add_concurrent_foreign_key :user_saved_views, :saved_views, column: :saved_view_id, on_delete: :cascade
  end

  def down
    with_lock_retries do
      remove_foreign_key :user_saved_views, column: :saved_view_id
    end
  end
end
